package com.flybits.context.plugins.language

import android.content.Context
import android.os.Bundle
import androidx.work.WorkerParameters
import com.flybits.commons.library.logging.Logger
import com.flybits.context.models.ContextData
import com.flybits.context.services.FlybitsContextPluginsWorker

const val TAG = "PluginLanguage"

/**
 * The [LanguageContextPluginWorker] is a worker responsible for retrieving the language currently used.
 * This will be triggered by `WorkManager` on start of language plugin to fetch the language used after specified interval.
 * The minimum interval for the worker to execute is 900 seconds.
 */
 class LanguageContextPluginWorker(context: Context, workerParameters: WorkerParameters) :
    FlybitsContextPluginsWorker(context, workerParameters) {
    override fun getData(): ContextData {
        Logger.setTag(TAG).d("Fetching Language Data ...")
        return LanguageData()
    }

    override fun getRequiredPermissions(): Array<String> {
        return arrayOf()
    }

    override fun initialize(bundle: Bundle?) {}

    override fun isSupported(): Boolean {
        return true
    }
}