package com.flybits.context.plugins.weather

import android.Manifest
import android.content.Context
import android.content.pm.PackageManager
import android.os.Build
import android.os.Bundle
import android.support.v4.content.ContextCompat
import androidx.work.WorkerParameters
import com.flybits.commons.library.exceptions.FlybitsException
import com.flybits.commons.library.logging.Logger
import com.flybits.context.models.ContextData
import com.flybits.context.plugins.FlybitsContextPlugin
import com.flybits.context.plugins.location.LocationData
import com.flybits.context.services.FlybitsContextPluginsWorker
import com.google.android.gms.location.FusedLocationProviderClient
import com.google.android.gms.location.LocationServices
import com.google.android.gms.tasks.Tasks
import java.util.concurrent.ExecutionException

const val TAG = "PluginWeather"

/**
 * The [WeatherContextPluginWorker] is a worker responsible for retrieving the weather by last location.
 * The minimum interval for the worker to execute is 900 seconds.
 * Permissions required are : ACCESS_FINE_LOCATION and ACCESS_COARSE_LOCATION.
 */
@Deprecated("WeatherContextPluginWorker will be updated in later releases. Avoid using this plugin.")
class WeatherContextPluginWorker(context: Context, workerParameters: WorkerParameters) :
    FlybitsContextPluginsWorker(context, workerParameters) {

    private var refreshTime: Long = 0
    private lateinit var fusedLocationClient: FusedLocationProviderClient

    override fun initialize(bundle: Bundle?) {
        refreshTime = inputData.getLong(FlybitsContextPlugin.EXTRA_MINIMUM_REFRESH_TIME, 60)
        fusedLocationClient = LocationServices.getFusedLocationProviderClient(applicationContext)
    }

    override fun isSupported(): Boolean {
        return Build.VERSION.SDK_INT < 23 || (ContextCompat.checkSelfPermission(
            applicationContext,
            Manifest.permission.ACCESS_FINE_LOCATION
        ) == PackageManager.PERMISSION_GRANTED && ContextCompat.checkSelfPermission(
            applicationContext,
            Manifest.permission.ACCESS_COARSE_LOCATION
        ) == PackageManager.PERMISSION_GRANTED)
    }

    override fun getData(): ContextData {
        Logger.setTag(TAG).d("Fetching Weather Data ...")
        try {
            // Using Tasks.await to get the result synchronously without callback.
            val lastLocation = Tasks.await(fusedLocationClient.lastLocation)
            return if (lastLocation != null) {
                LocationData(lastLocation)
            } else {
                throw FlybitsException("Issue retrieving location values.")
            }
        } catch (e: ExecutionException) {
            throw Exception(e.message)
        } catch (e: InterruptedException) {
            throw Exception(e.message)
        }
    }

    override fun getRequiredPermissions(): Array<String> {
        return arrayOf(
            Manifest.permission.ACCESS_FINE_LOCATION,
            Manifest.permission.ACCESS_COARSE_LOCATION
        )
    }
}