package com.flybits.context.deserializations;

import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.context.models.Rule;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeserializeRule extends IDeserializer<Rule> {

    @Override
    public String toJson(Rule obj) {

        if (obj == null){
            return "{}";
        }

        JSONObject object = new JSONObject();
        try{
            object.put("name", obj.getName());
        }catch (JSONException e){}
        try{
            object.put("description", obj.getDescription());
        }catch (JSONException e){}
        try{
            object.put("color", obj.getColor());
        }catch (JSONException e){}
        try{
            object.put("scope", obj.getScope().getKey());
        }catch (JSONException e){}
        try{
            object.put("stringRepresentation", obj.getStringRepresentation());
        }catch (JSONException e){}
        try{
            object.put("defaultEvaluation", obj.isDefaultEvaluation());
        }catch (JSONException e){}
        return object.toString();
    }

    @Override
    public Rule fromJson(JSONObject jObject) {
        try{
            String id = null, name = null, description = null, color = null, data = null,
                    ownerID = null, scope = null;

            boolean defaultEvaluation = false;
            if (!jObject.isNull("id")) {

                id = jObject.getString("id");

                if (!jObject.isNull("name")) {
                    name = jObject.getString("name");
                }
                if (!jObject.isNull("description")) {
                    description = jObject.getString("description");
                }
                if (!jObject.isNull("color")) {
                    color = jObject.getString("color");
                }
                if (!jObject.isNull("stringRepresentation")) {
                    data = jObject.getString("stringRepresentation");
                }
                if (!jObject.isNull("creator")) {
                    ownerID = jObject.getString("creator");
                }
                if (!jObject.isNull("scope")) {
                    scope = jObject.getString("scope");
                }
                if (!jObject.isNull("defaultEvaluation")) {
                    defaultEvaluation = jObject.getBoolean("defaultEvaluation");
                }
                return new Rule(id, name, description, color, data, scope, ownerID, defaultEvaluation);
            }
            return null;
        }catch (JSONException | NullPointerException exception){
            return null;
        }
    }

    @Override
    public Rule fromJson(JSONArray jsonArray) {
        return null;
    }
}
