/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context;

import android.content.SharedPreferences;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.ContextManager;
import com.flybits.context.ContextScope;
import com.flybits.context.models.ContextPriority;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.TaskParams;
import java.util.concurrent.TimeUnit;

public class ContextUploadingService
extends GcmTaskService {
    private static final String _TAG = "ContextUploadingService";
    public static final String PREF_REFRESH_RATE = "updateRate-ContextUpload";

    public void onInitializeTasks() {
        super.onInitializeTasks();
        SharedPreferences preferences = ContextScope.getContextPreferences(this.getBaseContext());
        long numberOfSeconds = preferences.getLong(PREF_REFRESH_RATE, 3600L);
        ContextManager.registerUploadingContext(this.getBaseContext(), ContextPriority.HIGH, numberOfSeconds, numberOfSeconds, TimeUnit.SECONDS);
    }

    public int onRunTask(TaskParams taskParams) {
        Logger.setTag((String)_TAG).d("Starting Context Uploading...");
        ContextManager.flushContextData(this.getBaseContext(), null);
        Logger.setTag((String)_TAG).d("...Finished Context Uploading");
        return 0;
    }

    public void onDestroy() {
        Logger.setTag((String)_TAG).d("...Destroyed Context Uploading");
        super.onDestroy();
    }
}

