/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.weather;

import android.content.Context;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.content.ContextCompat;
import androidx.work.WorkerParameters;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.models.ContextData;
import com.flybits.context.plugins.location.LocationData;
import com.flybits.context.services.FlybitsContextPluginsWorker;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.concurrent.ExecutionException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="WeatherContextPluginWorker will be updated in later releases. Avoid using this plugin.")
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/flybits/context/plugins/weather/WeatherContextPluginWorker;", "Lcom/flybits/context/services/FlybitsContextPluginsWorker;", "context", "Landroid/content/Context;", "workerParameters", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "fusedLocationClient", "Lcom/google/android/gms/location/FusedLocationProviderClient;", "refreshTime", "", "getData", "Lcom/flybits/context/models/ContextData;", "getRequiredPermissions", "", "", "()[Ljava/lang/String;", "initialize", "", "bundle", "Landroid/os/Bundle;", "isSupported", "", "context_release"})
public final class WeatherContextPluginWorker
extends FlybitsContextPluginsWorker {
    private long refreshTime;
    private FusedLocationProviderClient fusedLocationClient;

    @Override
    public void initialize(@Nullable Bundle bundle) {
        this.refreshTime = this.getInputData().getLong("flybits_minimum_refresh_time", 60L);
        FusedLocationProviderClient fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Context)this.getApplicationContext());
        Intrinsics.checkExpressionValueIsNotNull((Object)fusedLocationProviderClient, (String)"LocationServices.getFuse\u2026lient(applicationContext)");
        this.fusedLocationClient = fusedLocationProviderClient;
    }

    @Override
    public boolean isSupported() {
        return Build.VERSION.SDK_INT < 23 || ContextCompat.checkSelfPermission((Context)this.getApplicationContext(), (String)"android.permission.ACCESS_FINE_LOCATION") == 0 && ContextCompat.checkSelfPermission((Context)this.getApplicationContext(), (String)"android.permission.ACCESS_COARSE_LOCATION") == 0;
    }

    @Override
    @NotNull
    public ContextData getData() {
        Logger.setTag((String)"PluginWeather").d("Fetching Weather Data ...");
        try {
            FusedLocationProviderClient fusedLocationProviderClient = this.fusedLocationClient;
            if (fusedLocationProviderClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fusedLocationClient");
            }
            Location lastLocation = (Location)Tasks.await((Task)fusedLocationProviderClient.getLastLocation());
            return new LocationData(lastLocation);
        }
        catch (ExecutionException e) {
            throw (Throwable)new Exception(e.getMessage());
        }
        catch (InterruptedException e) {
            throw (Throwable)new Exception(e.getMessage());
        }
    }

    @Override
    @NotNull
    public String[] getRequiredPermissions() {
        return new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"};
    }

    public WeatherContextPluginWorker(@NotNull Context context, @NotNull WorkerParameters workerParameters) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)workerParameters, (String)"workerParameters");
        super(context, workerParameters);
    }
}

