/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.fitness;

import android.content.Context;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.plugins.fitness.IFitnessData;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.fitness.Fitness;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.DataReadResponse;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

class FitnessUtils {
    static final String _TAG = "FitnessData";
    private Context _context;

    FitnessUtils(Context context) {
        this._context = context;
    }

    void getStepsToday(IFitnessData callback) {
        Calendar calStart = Calendar.getInstance();
        Calendar calEnd = Calendar.getInstance();
        Date now = new Date();
        calStart.setTime(now);
        calStart.set(11, 0);
        calStart.set(12, 0);
        calStart.set(13, 1);
        this.getSteps(calStart.getTimeInMillis(), calEnd.getTimeInMillis(), callback);
    }

    private void getSteps(long startTime, long endTime, IFitnessData callback) {
        DataReadRequest readRequest = new DataReadRequest.Builder().aggregate(DataType.TYPE_STEP_COUNT_DELTA, DataType.AGGREGATE_STEP_COUNT_DELTA).bucketByTime(1, TimeUnit.DAYS).setTimeRange(startTime, endTime, TimeUnit.MILLISECONDS).build();
        GoogleSignInAccount account = GoogleSignIn.getLastSignedInAccount((Context)this._context);
        if (account != null) {
            Fitness.getHistoryClient((Context)this._context, (GoogleSignInAccount)account).readData(readRequest).addOnSuccessListener(dataReadResponse -> {
                int steps = this.getSteps((DataReadResponse)dataReadResponse);
                callback.onGetSteps(steps);
            }).addOnFailureListener(e -> callback.onCancel()).addOnCompleteListener(task -> {});
        }
    }

    private int getSteps(DataReadResponse dataReadResult) {
        int addition = 0;
        if (dataReadResult.getBuckets() == null || dataReadResult.getBuckets().size() == 0) {
            return -1;
        }
        for (Bucket bucket : dataReadResult.getBuckets()) {
            if (bucket.getDataSets().size() == 0) {
                return -1;
            }
            for (DataSet dataSet : bucket.getDataSets()) {
                if (dataSet.getDataPoints().size() == 0) {
                    return -1;
                }
                for (DataPoint point : dataSet.getDataPoints()) {
                    try {
                        addition += point.getValue(Field.FIELD_STEPS).asInt();
                    }
                    catch (Exception e) {
                        Logger.exception((String)"FitnessUtils.getSteps", (Exception)e);
                    }
                }
            }
        }
        Logger.setTag((String)_TAG).d("Number Of Steps: " + addition);
        return addition;
    }
}

