/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context;

import android.content.Context;
import android.content.SharedPreferences;
import android.database.SQLException;
import android.os.Bundle;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.PagedResponse;
import com.flybits.commons.library.models.internal.QueryBuilder;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.context.ContextManager;
import com.flybits.context.ContextScope;
import com.flybits.context.ReservedContextPlugin;
import com.flybits.context.db.ContextDatabase;
import com.flybits.context.deserializations.DeserializeContextPlugins;
import com.flybits.context.models.internal.Plugin;
import com.flybits.context.plugins.FlybitsContextPlugin;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.TaskParams;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ContextPluginsService
extends GcmTaskService {
    private static final String _TAG = "ContextPluginService";
    public static final String PREF_KEY_NUM_CPS = "ContextPlugin-size";
    public static final String PREF_KEY_REFRESH_CPS = "ContextPlugin-refreshTime";

    public void onInitializeTasks() {
        super.onInitializeTasks();
        SharedPreferences preferences = ContextScope.getContextPreferences(this.getBaseContext());
        HashMap<String, String> listOfClass = new HashMap<String, String>();
        int sizeOfCustomPlugins = preferences.getInt(PREF_KEY_NUM_CPS, 0);
        long timeToRefresh = preferences.getLong(PREF_KEY_REFRESH_CPS, 86400L);
        for (int i = 0; i < sizeOfCustomPlugins; ++i) {
            if (preferences.getString("item" + i, "").length() <= 0 || preferences.getString("value" + i, "").length() <= 0) continue;
            listOfClass.put(preferences.getString("item" + i, ""), preferences.getString("value" + i, ""));
        }
        ContextManager.registerForPluginUpdates(this.getBaseContext(), listOfClass, timeToRefresh);
    }

    public int onRunTask(TaskParams taskParams) {
        Logger.setTag((String)_TAG).d("Starting Context Plugin Retrieval...");
        HashMap<String, String> listOfCustomClasses = new HashMap<String, String>();
        if (taskParams.getExtras() != null) {
            Bundle bundle = taskParams.getExtras();
            for (int i = 0; i < bundle.getInt("listOfItems", 0); ++i) {
                listOfCustomClasses.put(bundle.getString("item" + i), bundle.getString("class" + i));
            }
        }
        return this.getPlugins(listOfCustomClasses) ? 0 : 2;
    }

    boolean getPlugins(HashMap<String, String> listOfCustomClasses) {
        try {
            DeserializeContextPlugins deserializer = new DeserializeContextPlugins();
            QueryBuilder builder = new QueryBuilder().setPaging(100L, 0L);
            QueryParameters params = new QueryParameters(builder);
            Result result = FlyAway.get((Context)this.getBaseContext(), (String)"/context/ctxschema/contextplugins", (QueryParameters)params, (IDeserializer)deserializer, (String)"Plugin.get");
            if (result != null && result.getResult() != null && result.getStatus() == RequestStatus.COMPLETED) {
                int index;
                List<Plugin> listOfOldPlugins = ContextDatabase.getDatabase(this.getBaseContext()).pluginDao().getAll();
                for (Plugin plugin : listOfOldPlugins) {
                    index = ((PagedResponse)result.getResult()).getItems().indexOf(plugin);
                    if (index == -1) {
                        Logger.setTag((String)_TAG).w("Plugin: " + plugin.getId() + " is NOT present any more");
                        ContextPluginsService.stopContextPlugin(this.getBaseContext(), listOfCustomClasses, plugin);
                        continue;
                    }
                    Logger.setTag((String)_TAG).w("Plugin: " + plugin.getId() + " All Good");
                }
                for (Plugin plugin : ((PagedResponse)result.getResult()).getItems()) {
                    index = listOfOldPlugins.indexOf(plugin);
                    if (index != -1) {
                        Plugin oldSavedPlugin = listOfOldPlugins.get(index);
                        if (plugin.isSupported() && !oldSavedPlugin.isSupported()) {
                            this.startContextPlugin(listOfCustomClasses, plugin, true);
                            continue;
                        }
                        if (!plugin.isSupported() && oldSavedPlugin.isSupported()) {
                            ContextPluginsService.stopContextPlugin(this.getBaseContext(), listOfCustomClasses, plugin);
                            continue;
                        }
                        if (!plugin.isSupported() || plugin.getRefreshRate() == oldSavedPlugin.getRefreshRate()) continue;
                        this.startContextPlugin(listOfCustomClasses, plugin, true);
                        continue;
                    }
                    if (!plugin.isSupported()) continue;
                    this.startContextPlugin(listOfCustomClasses, plugin, false);
                }
                return true;
            }
        }
        catch (SQLException | FlybitsException e) {
            Logger.exception((String)"ContextRulesService.onRunTask_II", (Exception)e);
        }
        return false;
    }

    private void startContextPlugin(HashMap<String, String> listOfCustomClasses, Plugin plugin, boolean isUpdate) {
        FlybitsContextPlugin.Builder pluginToBeCreated = null;
        if (plugin.isReserved()) {
            ReservedContextPlugin availablePlugin = ReservedContextPlugin.fromKey(plugin.getId());
            if (availablePlugin != ReservedContextPlugin.NOT_SUPPORTED) {
                pluginToBeCreated = new FlybitsContextPlugin.Builder(availablePlugin);
            } else {
                Logger.setTag((String)_TAG).w(plugin.getId() + " is currently not supported!");
            }
        } else if (listOfCustomClasses != null && listOfCustomClasses.get(plugin.getId()) != null) {
            try {
                Class<?> c2 = Class.forName(listOfCustomClasses.get(plugin.getId()));
                pluginToBeCreated = new FlybitsContextPlugin.Builder(c2, true);
            }
            catch (ClassNotFoundException e) {
                Logger.setTag((String)_TAG).w("The class: " + listOfCustomClasses.get(plugin.getId()) + " was not found");
            }
        } else {
            Logger.setTag((String)_TAG).w(plugin.getId() + " has currently has not been implemented by the Application.");
        }
        if (pluginToBeCreated != null) {
            pluginToBeCreated.setRefreshTime(plugin.getRefreshRate(), plugin.getRefreshRate(), TimeUnit.SECONDS);
            FlybitsContextPlugin pluginBuilt = pluginToBeCreated.build();
            ContextManager.start(this.getBaseContext(), pluginBuilt);
            plugin.setClassName(pluginBuilt.getContextPluginRetriever().getCanonicalName());
            if (isUpdate) {
                ContextDatabase.getDatabase(this.getBaseContext()).pluginDao().update(plugin);
            } else {
                ContextDatabase.getDatabase(this.getBaseContext()).pluginDao().insert(plugin);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void stopContextPlugin(Context mContext, HashMap<String, String> listOfCustomClasses, Plugin plugin) {
        FlybitsContextPlugin.Builder pluginToBeCreated = null;
        if (plugin.isReserved()) {
            ReservedContextPlugin availablePlugin = ReservedContextPlugin.fromKey(plugin.getId());
            if (availablePlugin == ReservedContextPlugin.NOT_SUPPORTED) return;
            pluginToBeCreated = new FlybitsContextPlugin.Builder(availablePlugin);
        } else if (listOfCustomClasses != null && listOfCustomClasses.get(plugin.getId()) != null) {
            try {
                Class<?> c2 = Class.forName(listOfCustomClasses.get(plugin.getId()));
                pluginToBeCreated = new FlybitsContextPlugin.Builder(c2);
            }
            catch (ClassNotFoundException e) {
                Logger.setTag((String)_TAG).w("The class: " + listOfCustomClasses.get(plugin.getId()) + " was not found");
                return;
            }
        } else {
            Logger.setTag((String)_TAG).w(plugin.getId() + " has currently has not been implemented by the Application.");
            return;
        }
        ContextManager.stop(mContext, pluginToBeCreated.build());
        ContextDatabase.getDatabase(mContext).pluginDao().delete(plugin);
    }

    public void onDestroy() {
        Logger.setTag((String)_TAG).d("... Destroyed Context Plugin Retrieval");
        super.onDestroy();
    }
}

