/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.activity;

import android.os.Parcel;
import android.os.Parcelable;
import com.flybits.context.models.ContextData;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityData
extends ContextData
implements Parcelable {
    private boolean cycling;
    private boolean driving;
    private boolean running;
    private boolean stationary;
    private boolean unknown;
    private boolean walking;
    public static final Parcelable.Creator<ActivityData> CREATOR = new Parcelable.Creator<ActivityData>(){

        public ActivityData createFromParcel(Parcel in) {
            return new ActivityData(in);
        }

        public ActivityData[] newArray(int size) {
            return new ActivityData[size];
        }
    };

    public ActivityData() {
    }

    protected ActivityData(Parcel in) {
        this.cycling = in.readInt() == 1;
        this.walking = in.readInt() == 1;
        this.driving = in.readInt() == 1;
        this.running = in.readInt() == 1;
        this.unknown = in.readInt() == 1;
        this.stationary = in.readInt() == 1;
        this.setTime(in.readLong());
    }

    public ActivityData(boolean cycling, boolean driving, boolean running, boolean stationary, boolean unknown, boolean walking) {
        this.cycling = cycling;
        this.driving = driving;
        this.running = running;
        this.stationary = stationary;
        this.unknown = unknown;
        this.walking = walking;
    }

    public boolean isCycling() {
        return this.cycling;
    }

    public boolean isDriving() {
        return this.driving;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isStationary() {
        return this.stationary;
    }

    public boolean isUnknown() {
        return this.unknown;
    }

    public boolean isWalking() {
        return this.walking;
    }

    @Override
    public String toJson() {
        JSONObject object = new JSONObject();
        try {
            object.put("cycling", this.cycling);
            object.put("walking", this.walking);
            object.put("driving", this.driving);
            object.put("running", this.running);
            object.put("unknown", this.unknown);
            object.put("stationary", this.stationary);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return object.toString();
    }

    @Override
    public void fromJson(String json) {
        try {
            JSONObject jsonObj = new JSONObject(json);
            this.cycling = jsonObj.getBoolean("cycling");
            this.walking = jsonObj.getBoolean("walking");
            this.driving = jsonObj.getBoolean("driving");
            this.running = jsonObj.getBoolean("running");
            this.unknown = jsonObj.getBoolean("unknown");
            this.stationary = jsonObj.getBoolean("stationary");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityData that = (ActivityData)o;
        if (this.cycling != that.cycling) {
            return false;
        }
        if (this.driving != that.driving) {
            return false;
        }
        if (this.running != that.running) {
            return false;
        }
        if (this.stationary != that.stationary) {
            return false;
        }
        if (this.unknown != that.unknown) {
            return false;
        }
        return this.walking == that.walking;
    }

    @Override
    public String getPluginID() {
        return "ctx.sdk.activity";
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.cycling ? 1 : 0);
        dest.writeInt(this.walking ? 1 : 0);
        dest.writeInt(this.driving ? 1 : 0);
        dest.writeInt(this.running ? 1 : 0);
        dest.writeInt(this.unknown ? 1 : 0);
        dest.writeInt(this.stationary ? 1 : 0);
        dest.writeLong(this.getTime());
    }

    public static enum ActivityType {
        UNKNOWN(-99),
        STILL(1),
        WALKING(2),
        RUNNING(3),
        IN_VEHICLE(4),
        ON_BICYCLE(5);

        private final int key;

        private ActivityType(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public static ActivityType fromKey(int key) {
            for (ActivityType type : ActivityType.values()) {
                if (type.getKey() != key) continue;
                return type;
            }
            return UNKNOWN;
        }
    }
}

