/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.fitness;

import android.content.Context;
import android.os.Bundle;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.models.ContextData;
import com.flybits.context.plugins.fitness.FitnessData;
import com.flybits.context.plugins.fitness.FitnessUtils;
import com.flybits.context.plugins.fitness.IFitnessData;
import com.flybits.context.services.FlybitsContextPluginService;
import java.util.concurrent.TimeUnit;

public class FitnessContextPluginService
extends FlybitsContextPluginService
implements IFitnessData {
    private static final String _TAG = "PluginFitness";

    @Override
    public void initialize(Bundle bundle) {
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public ContextData getData() {
        Logger.setTag((String)_TAG).d("Fetching Data ...");
        FitnessUtils fitnessUtils = new FitnessUtils((Context)this);
        fitnessUtils.getStepsToday(this);
        this.wait(5L, TimeUnit.SECONDS);
        return null;
    }

    @Override
    public void onDestroy() {
        Logger.setTag((String)_TAG).d("...Destroyed");
        super.onDestroy();
    }

    @Override
    public void onGetSteps(long steps) {
        FitnessData data = new FitnessData(steps);
        long timeInSec = data.getTime() > 0L ? data.getTime() : System.currentTimeMillis() / 1000L;
        data.update(this.getBaseContext(), timeInSec, null);
    }

    @Override
    public void onCancel() {
        Logger.setTag((String)_TAG).d("Error Fetching Fitness Data.");
    }

    @Override
    public String[] getRequiredPermissions() {
        return new String[0];
    }
}

