/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.fitness;

import android.content.Context;
import android.os.Bundle;
import androidx.work.WorkerParameters;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.models.ContextData;
import com.flybits.context.plugins.fitness.FitnessData;
import com.flybits.context.plugins.fitness.FitnessUtils;
import com.flybits.context.plugins.fitness.IFitnessData;
import com.flybits.context.services.FlybitsContextPluginsWorker;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\tH\u0016J\u0018\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lcom/flybits/context/plugins/fitness/FitnessContextPluginWorker;", "Lcom/flybits/context/services/FlybitsContextPluginsWorker;", "Lcom/flybits/context/plugins/fitness/IFitnessData;", "context", "Landroid/content/Context;", "workerParameters", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "totalSteps", "", "getTotalSteps", "()J", "setTotalSteps", "(J)V", "getData", "Lcom/flybits/context/models/ContextData;", "getRequiredPermissions", "", "", "()[Ljava/lang/String;", "initialize", "", "bundle", "Landroid/os/Bundle;", "isSupported", "", "onCancel", "onGetSteps", "steps", "wait", "time", "unit", "Ljava/util/concurrent/TimeUnit;", "context_release"})
public final class FitnessContextPluginWorker
extends FlybitsContextPluginsWorker
implements IFitnessData {
    private long totalSteps;

    public final long getTotalSteps() {
        return this.totalSteps;
    }

    public final void setTotalSteps(long l) {
        this.totalSteps = l;
    }

    @Override
    public void onGetSteps(long steps) {
        this.totalSteps = steps;
    }

    @Override
    public void onCancel() {
        Logger.setTag((String)"PluginFitness").d("Error Fetching Fitness Data.");
    }

    @Override
    @NotNull
    public ContextData getData() {
        Logger.setTag((String)"PluginFitness").d("Fetching Fitness Data ...");
        try {
            FitnessUtils fitnessUtils = new FitnessUtils(this.getApplicationContext());
            fitnessUtils.getStepsToday(this);
            this.wait(5L, TimeUnit.SECONDS);
            return new FitnessData(this.totalSteps);
        }
        catch (Exception e) {
            throw (Throwable)new Exception(e.getMessage());
        }
    }

    @Override
    @NotNull
    public String[] getRequiredPermissions() {
        return new String[0];
    }

    @Override
    public void initialize(@Nullable Bundle bundle) {
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    private final void wait(long time, TimeUnit unit) {
        long mServiceStartTime = System.currentTimeMillis();
        long waitInMilli = unit.toMillis(time);
        while (System.currentTimeMillis() - mServiceStartTime <= waitInMilli) {
            Thread.yield();
        }
    }

    public FitnessContextPluginWorker(@NotNull Context context, @NotNull WorkerParameters workerParameters) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)workerParameters, (String)"workerParameters");
        super(context, workerParameters);
    }
}

