/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.models;

import android.arch.persistence.room.Ignore;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.context.ContextManager;
import com.flybits.context.db.ContextDatabase;
import com.flybits.context.models.BasicData;
import com.flybits.context.utils.ContextUtilities;
import com.flybits.internal.DeboucerContextReporting;
import com.flybits.internal.Debounce;
import com.flybits.internal.Debouncer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class ContextData
implements Parcelable {
    @Ignore
    private long timeInSeconds;

    public ContextData() {
        this.setTime(System.currentTimeMillis() / 1000L);
    }

    public abstract boolean equals(Object var1);

    public abstract void fromJson(String var1);

    public long getTime() {
        return this.timeInSeconds;
    }

    public abstract String getPluginID();

    public void setTime(long time) {
        this.timeInSeconds = time;
    }

    public abstract String toJson();

    public void update(final Context context, final long timeInSec) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (ContextData.this.updateDB(context, timeInSec)) {
                    ContextUtilities.broadcastContextUpdate(context, ContextData.this, ContextData.this.getPluginID(), timeInSec);
                    DeboucerContextReporting task = new DeboucerContextReporting(context);
                    Debouncer.getInstance().call((Debounce)task);
                }
            }
        });
    }

    @Deprecated
    public BasicResult update(Context context, long timeInSec, BasicResultCallback callback) {
        this.update(context, timeInSec);
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        BasicResult basicResult = new BasicResult(callback, handler, executorService);
        Result result = new Result(200, "");
        basicResult.setResult(result);
        return basicResult;
    }

    public BasicResult updateNow(final Context context, BasicResultCallback callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult basicResult = new BasicResult(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                long currentTime = System.currentTimeMillis() / 1000L;
                if (ContextData.this.updateDB(context, currentTime)) {
                    ContextUtilities.broadcastContextUpdate(context, ContextData.this, ContextData.this.getPluginID(), currentTime);
                    ContextManager.flushContextData(context, new BasicResultCallback(){

                        public void onSuccess() {
                            Result result = new Result(200, "");
                            basicResult.setResult(result);
                        }

                        public void onException(FlybitsException exception) {
                            Result result = new Result(exception, "");
                            basicResult.setResult(result);
                        }
                    });
                } else {
                    Result result = new Result(200, "");
                    basicResult.setResult(result);
                }
            }
        });
        return basicResult;
    }

    protected boolean updateDB(Context context, long timeInSeconds) {
        String pluginID = this.getPluginID();
        BasicData dataFromCursor = ContextDatabase.getDatabase(context).basicDataDao().get(pluginID);
        if (dataFromCursor != null) {
            if (!(dataFromCursor.getValueAsString() == null || dataFromCursor.getValueAsString().equals(this.toJson()) && dataFromCursor.isSent())) {
                BasicData tempData = ContextDatabase.getDatabase(context).basicDataDao().get(pluginID);
                tempData.setTimestamp(timeInSeconds);
                tempData.setValueAsString(this.toJson());
                tempData.setSent(false);
                Logger.setTag((String)"FlybitsContext").i("Update: " + this.toJson());
                ContextDatabase.getDatabase(context).basicDataDao().update(tempData);
                return true;
            }
        } else {
            BasicData dataBasic = new BasicData(pluginID, timeInSeconds, false, this.toJson());
            Logger.setTag((String)"FlybitsContext").i("Insert: " + this.toJson());
            ContextDatabase.getDatabase(context).basicDataDao().insert(dataBasic);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.toJson();
    }
}

