package com.flybits.context.plugins.fitness;

import android.os.Bundle;

import com.flybits.commons.library.logging.Logger;
import com.flybits.context.models.ContextData;
import com.flybits.context.services.FlybitsContextPluginService;

import java.util.concurrent.TimeUnit;

public class FitnessContextPluginService extends FlybitsContextPluginService implements IFitnessData {

    private final static String _TAG = "PluginFitness";

    @Override
    public void initialize(Bundle bundle) {
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public ContextData getData() {
        Logger.setTag(_TAG).d("Fetching Data ...");

        FitnessUtils fitnessUtils = new FitnessUtils(this);
        fitnessUtils.getStepsToday(this);
        wait(5, TimeUnit.SECONDS);

        return null;
    }


    @Override
    public void onDestroy() {
        Logger.setTag(_TAG).d("...Destroyed");
        super.onDestroy();
    }

    @Override
    public void onGetSteps(long steps) {
        FitnessData data = new FitnessData(steps);
        long timeInSec = (data.getTime() > 0) ? data.getTime() : (System.currentTimeMillis() / 1000);
        data.update(getBaseContext(), timeInSec, null);
    }

    @Override
    public void onCancel() {
        Logger.setTag(_TAG).d("Error Fetching Fitness Data.");
    }

    @Override
    public String[] getRequiredPermissions() {
        return new String[0];
    }

}
