/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.services;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.flybits.commons.library.exceptions.PermissionNotSetException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.models.ContextData;
import com.flybits.context.services.ContextDataRetriever;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/flybits/context/services/FlybitsContextPluginsWorker;", "Landroidx/work/Worker;", "Lcom/flybits/context/services/ContextDataRetriever;", "context", "Landroid/content/Context;", "workerParameters", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "_TAG", "", "doWork", "Landroidx/work/ListenableWorker$Result;", "hasRequiredPermissions", "", "context_release"})
public abstract class FlybitsContextPluginsWorker
extends Worker
implements ContextDataRetriever {
    private final String _TAG = "ContextPluginService";

    @NotNull
    public ListenableWorker.Result doWork() {
        ListenableWorker.Result result;
        Bundle extras = new Bundle();
        Data data = this.getInputData();
        Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"inputData");
        for (String key : data.getKeyValueMap().keySet()) {
            Data data2 = this.getInputData();
            Intrinsics.checkExpressionValueIsNotNull((Object)data2, (String)"inputData");
            extras.putString(key, data2.getKeyValueMap().values().toString());
        }
        this.initialize(extras);
        Context context = this.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
        if (this.hasRequiredPermissions(context)) {
            ListenableWorker.Result result2;
            FlybitsContextPluginsWorker flybitsContextPluginsWorker = this;
            boolean bl = false;
            boolean bl2 = false;
            FlybitsContextPluginsWorker $this$run = flybitsContextPluginsWorker;
            boolean bl3 = false;
            try {
                ContextData data3 = $this$run.getData();
                long timeInSec = data3.getTime() > 0L ? data3.getTime() : System.currentTimeMillis() / (long)1000;
                data3.update($this$run.getApplicationContext(), timeInSec);
                result2 = ListenableWorker.Result.success();
            }
            catch (Exception exception) {
                Logger.exception((String)"ContextData", (Exception)exception);
                result2 = ListenableWorker.Result.retry();
            }
            ListenableWorker.Result result3 = result2;
            result = result3;
            Intrinsics.checkExpressionValueIsNotNull((Object)result3, (String)"run {\n                tr\u2026          }\n            }");
        } else {
            ListenableWorker.Result result4 = ListenableWorker.Result.failure();
            result = result4;
            Intrinsics.checkExpressionValueIsNotNull((Object)result4, (String)"Result.failure()");
        }
        return result;
    }

    private final boolean hasRequiredPermissions(Context context) throws PermissionNotSetException {
        String[] listOfPermissions;
        String[] $this$forEach$iv = listOfPermissions = this.getRequiredPermissions();
        boolean $i$f$forEach = false;
        int n = 0;
        String[] stringArray = $this$forEach$iv;
        int n2 = stringArray.length;
        if (n < n2) {
            String element$iv;
            String permission2 = element$iv = stringArray[n];
            boolean bl = false;
            if (Build.VERSION.SDK_INT > 22) {
                return ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
            }
            try {
                PackageManager manager = context.getPackageManager();
                if (manager != null) {
                    PackageInfo info = manager.getPackageInfo(context.getPackageName(), 4096);
                    if (info.requestedPermissions != null) {
                        Intrinsics.checkExpressionValueIsNotNull((Object)info.requestedPermissions, (String)"info.requestedPermissions");
                        String[] $this$forEach$iv2 = info.requestedPermissions;
                        boolean $i$f$forEach2 = false;
                        String[] stringArray2 = $this$forEach$iv2;
                        int n3 = stringArray2.length;
                        int n4 = 0;
                        if (n4 < n3) {
                            String element$iv2;
                            String it = element$iv2 = stringArray2[n4];
                            boolean bl2 = false;
                            return Intrinsics.areEqual((Object)it, (Object)permission2);
                        }
                    }
                }
            }
            catch (PackageManager.NameNotFoundException exception) {
                Logger.exception((String)"getPackageInfo()", (Exception)((Exception)((Object)exception)));
                return false;
            }
            Log.e((String)"Flybits", (String)("You are attempting to register to this context plugin without enabling the " + permission2 + " permission. This is not possible. Please include this permission in your manifest. " + "For more information please visit https://developer.flybits.com/android-getting-started.html#context"));
            return false;
        }
        return true;
    }

    public FlybitsContextPluginsWorker(@NotNull Context context, @NotNull WorkerParameters workerParameters) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)workerParameters, (String)"workerParameters");
        super(context, workerParameters);
        this._TAG = "ContextPluginService";
    }
}

