package com.flybits.context.plugins.weather;

import android.Manifest;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.plugins.location.LocationContextPluginService;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;

public class WeatherContextPluginService extends LocationContextPluginService implements
        GoogleApiClient.ConnectionCallbacks,
        GoogleApiClient.OnConnectionFailedListener,
        LocationListener {

    private LocationRequest mLocationRequest;
    private final static String _TAG = "PluginWeather";

    private long minDisplacement = -1;

    @Override
    public void initialize(Bundle bundle) {

        super.initialize(bundle);

        if (bundle != null && bundle.containsKey("minDisplacement")){
                minDisplacement = bundle.getLong("minDisplacement");
        }
    }

    @Override
    public boolean isSupported() {
        return Build.VERSION.SDK_INT < 23 ||
                ContextCompat.checkSelfPermission(getBaseContext(), Manifest.permission.ACCESS_COARSE_LOCATION) == PackageManager.PERMISSION_GRANTED;
    }

    @Override
    public void onConnected(@Nullable Bundle bundle) {

        if (isSupported()) {
            Logger.setTag(_TAG).d("Google API Services connected!");
            mLocationRequest = LocationRequest.create()
                    .setPriority(LocationRequest.PRIORITY_NO_POWER)
                    .setInterval(getRefreshTime() * 1000);

            if (minDisplacement > 10) {
                mLocationRequest.setSmallestDisplacement(minDisplacement);
            }
            LocationServices.FusedLocationApi.requestLocationUpdates(getGoogleApiClient(), mLocationRequest, this);
        }
    }

}
