package com.flybits.context.deserializations;

import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.PagedResponse;
import com.flybits.commons.library.models.internal.Pagination;
import com.flybits.context.models.internal.Plugin;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class DeserializeContextPlugins extends IDeserializer<PagedResponse<Plugin>> {

    @Override
    public String toJson(PagedResponse<Plugin> obj) {

        if (obj == null || obj.getItems() == null || obj.getItems().size() == 0){
            return "[]";
        }

        JSONArray array = new JSONArray();
        for (Plugin rule : obj.getItems()){
            JSONObject object = new JSONObject();
            try{
                object.put("id", rule.getId());
            }catch(JSONException e){}
            try{
                object.put("name", rule.getName());
            }catch(JSONException e){}
            try{
                object.put("isEnabled", rule.isSupported());
            }catch(JSONException e){}
            try{
                object.put("refreshRate", rule.getRefreshRate());
            }catch(JSONException e){}

            array.put(object);
        }
        return array.toString();
    }

    @Override
    public PagedResponse<Plugin> fromJson(JSONObject jsonObject) {
        return null;
    }

    @Override
    public PagedResponse<Plugin> fromJson(JSONArray jsonArray) {
        try {
            ArrayList<Plugin> plugins = new ArrayList<>();

            for(int i = 0; i < jsonArray.length(); i++) {
                JSONObject elementObj = jsonArray.getJSONObject(i);
                String id = elementObj.getString("uid");
                String name = elementObj.getString("name");

                boolean isReserved = false, isEnabled = false, isSupported = false; long refreshRate = -1;

                if (!elementObj.isNull("isReserved")) {
                    isReserved = elementObj.getBoolean("isReserved");
                }

                if (!elementObj.isNull("supportedPlatforms")) {

                    JSONArray isSupportedArray = elementObj.getJSONArray("supportedPlatforms");
                    for (int j = 0; j < isSupportedArray.length(); j++){
                        if (isSupportedArray.getString(j).equalsIgnoreCase("android")){
                            isSupported = true;
                            break;
                        }
                    }
                }else{
                    isSupported = true;
                }

                if (!elementObj.isNull("tenantConfig")) {

                    JSONObject tenantConfigObject = elementObj.getJSONObject("tenantConfig");

                    if (!tenantConfigObject.isNull("isEnabled")) {
                        isEnabled = tenantConfigObject.getBoolean("isEnabled");
                    }
                    if (!tenantConfigObject.isNull("refreshRate")) {
                        refreshRate = tenantConfigObject.getLong("refreshRate");
                    }
                }

                HashMap<String, String> listOfAttributes    = new HashMap<>();
                if (!elementObj.isNull("values")) {

                    JSONObject valuesObject = elementObj.getJSONObject("values");
                    Iterator keys = valuesObject.keys();
                    while(keys.hasNext()) {

                        String dynamicKeys = (String)keys.next();
                        JSONObject valuesObjectKey = valuesObject.getJSONObject(dynamicKeys);

                        if (!valuesObjectKey.isNull("uid") && !valuesObjectKey.isNull("valueType")){
                            listOfAttributes.put(valuesObjectKey.getString("uid"), valuesObjectKey.getString("valueType"));
                        }
                    }
                }

                plugins.add(new Plugin(id, name, refreshRate, isEnabled, isReserved, isSupported, listOfAttributes));
            }
            return new PagedResponse<Plugin>(plugins, new Pagination(jsonArray.length(), 0, jsonArray.length()));
        }catch (JSONException | NullPointerException e){
            Logger.exception("DeserializeContextPlugins.fromJson", e);
            return null;
        }
    }
}
