package com.flybits.context.plugins.activity;

import android.app.PendingIntent;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.models.ContextData;
import com.flybits.context.services.FlybitsContextPluginService;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.ActivityRecognition;

import java.util.concurrent.TimeUnit;

public class ActivityContextPluginService extends FlybitsContextPluginService implements
        GoogleApiClient.ConnectionCallbacks,
        GoogleApiClient.OnConnectionFailedListener{

    private GoogleApiClient mGoogleApiClient;
    private final static String _TAG = "PluginActivity";

    @Override
    public void initialize(Bundle bundle) {
        if (mGoogleApiClient == null) {
            mGoogleApiClient = new GoogleApiClient.Builder(this)
                    .addApi(ActivityRecognition.API)
                    .addConnectionCallbacks(this)
                    .addOnConnectionFailedListener(this)
                    .build();
        }
    }

    @Override
    public String[] getRequiredPermissions() {
        return new String[]{"com.google.android.gms.permission.ACTIVITY_RECOGNITION"};
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public ContextData getData() {
        Logger.setTag(_TAG).d("Fetching Data ... ");

        if (mGoogleApiClient != null) {
            if (!mGoogleApiClient.isConnected()) {
                mGoogleApiClient.blockingConnect(10, TimeUnit.SECONDS);
            }

            if (mGoogleApiClient.isConnected()) {
                Intent i = new Intent(getBaseContext(), DeviceRecognitionServiceIntent.class);
                PendingIntent mActivityRecongPendingIntent = PendingIntent.getService(getBaseContext(),
                        0, i, PendingIntent.FLAG_ONE_SHOT);

                ActivityRecognition.ActivityRecognitionApi.requestActivityUpdates(mGoogleApiClient, 0,
                        mActivityRecongPendingIntent);
            }
        }

        return null;
    }

    @Override
    public void onConnected(@Nullable Bundle bundle) {
        Logger.setTag(_TAG).i("GoogleAPIClient: onConnected");
    }

    @Override
    public void onConnectionSuspended(int i) {
        Logger.setTag(_TAG).w("GoogleAPIClient: onConnectionSuspended: " + i);
    }

    @Override
    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Logger.setTag(_TAG).e("GoogleAPIClient: onConnectionFailed: + " + connectionResult);
    }

    @Override
    public void onDestroy() {
        if (mGoogleApiClient != null && mGoogleApiClient.isConnected()) {
            mGoogleApiClient.disconnect();
        }
        Logger.setTag(_TAG).d("...Destroyed");
        super.onDestroy();
    }


}
