package com.flybits.context.db.dao

import android.arch.persistence.room.*
import com.flybits.context.plugins.FlybitsContextPlugin

@Dao
interface FlybitsContextPluginDAO {

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insert(flybitsContextPlugin: FlybitsContextPlugin)

    @Update
    fun update(flybitsContextPlugin: FlybitsContextPlugin)

    @Delete
    fun delete(flybitsContextPlugin: FlybitsContextPlugin)

    @Query("SELECT * FROM ${FlybitsContextPlugin.TABLE}")
    fun getAll(): List<FlybitsContextPlugin>

    @Query("DELETE FROM ${FlybitsContextPlugin.TABLE}")
    fun deleteAll()

}