/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.beacon;

import android.app.Notification;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.PagedResponse;
import com.flybits.commons.library.models.internal.QueryBuilder;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.context.ContextManager;
import com.flybits.context.db.ContextDatabase;
import com.flybits.context.deserializations.DeserializeMonitoredBeacons;
import com.flybits.context.models.ContextData;
import com.flybits.context.plugins.beacon.BeaconActive;
import com.flybits.context.plugins.beacon.BeaconDataList;
import com.flybits.context.plugins.beacon.BeaconMonitored;
import com.flybits.context.plugins.beacon.BeaconType;
import com.flybits.context.services.FlybitsContextPluginService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.Identifier;
import org.altbeacon.beacon.RangeNotifier;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.powersave.BackgroundPowerSaver;
import org.altbeacon.beacon.startup.BootstrapNotifier;
import org.altbeacon.beacon.startup.RegionBootstrap;

public class BeaconScanningService
extends FlybitsContextPluginService
implements BootstrapNotifier,
RangeNotifier {
    static final String API_CONTEXT_BEACONS_GETTOMONITOR = "/context/beacons/monitoring";
    private final long SCAN_PERIOD = 10000L;
    private final String _TAG = "BeaconScanningService";
    private final String FRAME_IBEACON = "m:0-3=4c000215,i:4-19,i:20-21,i:22-23,p:24-24";
    private BackgroundPowerSaver backgroundPowerSaver;
    private RegionBootstrap regionBootstrap;
    private BeaconManager mBeaconManager;

    @Override
    public void onCreate() {
        super.onCreate();
        this.startForeground(1, new Notification());
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        this.initialize(intent.getExtras());
        return 3;
    }

    @Override
    public void initialize(Bundle bundle) {
        this.setupBeaconMetadata();
    }

    private void setupBeaconMetadata() {
        this.mBeaconManager = BeaconManager.getInstanceForApplication((Context)this);
        this.mBeaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout("s:0-1=feaa,m:2-2=00,p:3-3:-41,i:4-13,i:14-19"));
        this.mBeaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout("x,s:0-1=feaa,m:2-2=20,d:3-3,d:4-5,d:6-7,d:8-11,d:12-15"));
        this.mBeaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout("s:0-1=feaa,m:2-2=10,p:3-3:-41,i:4-21v"));
        this.mBeaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout("m:0-3=4c000215,i:4-19,i:20-21,i:22-23,p:24-24"));
        this.mBeaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout("m:2-3=beac,i:4-19,i:20-21,i:22-23,p:24-24,d:25-25"));
        new GetMonitoredBeacons().execute(new Void[0]);
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Override
    public void onDestroy() {
        if (this.regionBootstrap != null) {
            this.regionBootstrap.disable();
        }
        super.onDestroy();
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public ContextData getData() {
        return null;
    }

    @Override
    public String[] getRequiredPermissions() {
        return new String[0];
    }

    public void onBeaconServiceConnect() {
    }

    public void didEnterRegion(Region region) {
        Logger.setTag((String)"BeaconScanningService").d("Did Enter Region: " + region);
        try {
            this.mBeaconManager.startRangingBeaconsInRegion(region);
            Logger.setTag((String)"BeaconScanningService").d("StartRanging");
        }
        catch (RemoteException e) {
            Logger.exception((String)"BeaconScanningService.didEnterRegion", (Exception)((Object)e));
        }
    }

    public void didExitRegion(final Region region) {
        Logger.setTag((String)"BeaconScanningService").d("Did Exit Region: " + region);
        new AsyncTask<Void, Void, List<BeaconActive>>(){

            protected List<BeaconActive> doInBackground(Void ... unused) {
                List<BeaconActive> listOfBeacons = ContextDatabase.getDatabase(BeaconScanningService.this.getBaseContext()).beaconActiveDao().getAll();
                return listOfBeacons;
            }

            protected void onPostExecute(List<BeaconActive> listOfBeacons) {
                if (listOfBeacons != null && listOfBeacons.size() == 0) {
                    try {
                        BeaconScanningService.this.mBeaconManager.stopRangingBeaconsInRegion(region);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.execute((Object[])new Void[0]);
    }

    public void didDetermineStateForRegion(int i, Region region) {
    }

    public void didRangeBeaconsInRegion(final Collection<Beacon> beacons, final Region region) {
        Logger.setTag((String)"BeaconScanningService").d("Did Range Beacons In Region:" + beacons.size());
        new AsyncTask<Void, Void, List<BeaconActive>>(){

            protected List<BeaconActive> doInBackground(Void ... unused) {
                List<BeaconActive> listOfBeacons = ContextDatabase.getDatabase(BeaconScanningService.this.getBaseContext()).beaconActiveDao().getAll();
                Logger.setTag((String)"BeaconScanningService").d("Number of Total Rows: " + listOfBeacons.size());
                List<BeaconActive> listOfBeaconsNotInRange = ContextDatabase.getDatabase(BeaconScanningService.this.getBaseContext()).beaconActiveDao().getAllNotInRange();
                Logger.setTag((String)"BeaconScanningService").d("Number of Rows To Delete: " + listOfBeaconsNotInRange.size());
                if (listOfBeaconsNotInRange.size() > 0) {
                    long currentTime = System.currentTimeMillis() / 1000L;
                    for (BeaconActive active : listOfBeacons) {
                        if (currentTime - active.getLastSeen() <= 30L) continue;
                        active.setInRange(false);
                        ContextDatabase.getDatabase(BeaconScanningService.this.getBaseContext()).beaconActiveDao().update(active);
                        Logger.setTag((String)"BeaconScanningService").d("Set To False: " + active.getCompositeID());
                    }
                }
                for (Beacon beacon : beacons) {
                    BeaconActive beaconWithCompositeID;
                    Logger.setTag((String)"BeaconScanningService").d("The beacon " + beacon.toString() + " is about " + beacon.getDistance() + " meters away.");
                    String compositeID = beacon.getId1().toString();
                    if (beacon.getId2() != null) {
                        compositeID = compositeID + "_" + beacon.getId2().toString();
                    }
                    if (beacon.getId3() != null) {
                        compositeID = compositeID + "_" + beacon.getId3().toString();
                    }
                    if ((beaconWithCompositeID = ContextDatabase.getDatabase(BeaconScanningService.this.getBaseContext()).beaconActiveDao().get(compositeID)) != null) {
                        Logger.setTag((String)"BeaconScanningService").d("This beacon has been previously saved");
                        beaconWithCompositeID.setInRange(true);
                        beaconWithCompositeID.setTimestamp(System.currentTimeMillis() / 1000L);
                        ContextDatabase.getDatabase(BeaconScanningService.this.getBaseContext()).beaconActiveDao().update(beaconWithCompositeID);
                        continue;
                    }
                    Logger.setTag((String)"BeaconScanningService").d("This beacon has NOT been previously saved");
                    BeaconActive activeBeacon = new BeaconActive(beacon);
                    activeBeacon.setInRange(true);
                    ContextDatabase.getDatabase(BeaconScanningService.this.getBaseContext()).beaconActiveDao().insert(activeBeacon);
                }
                return ContextDatabase.getDatabase(BeaconScanningService.this.getBaseContext()).beaconActiveDao().getAll();
            }

            protected void onPostExecute(List<BeaconActive> listOfBeacons) {
                if (listOfBeacons.size() == 0) {
                    try {
                        BeaconScanningService.this.mBeaconManager.stopRangingBeaconsInRegion(region);
                    }
                    catch (RemoteException e) {
                        Logger.exception((String)"BeaconScanningService.didRangeBeaconsInRegion", (Exception)((Object)e));
                    }
                } else {
                    new UploadBeaconData(listOfBeacons).execute(new Void[0]);
                }
            }
        }.execute((Object[])new Void[0]);
    }

    public class GetMonitoredBeacons
    extends AsyncTask<Void, Integer, List<Region>> {
        protected List<Region> doInBackground(Void ... args) {
            try {
                List<BeaconMonitored> listOfMonitored = ContextDatabase.getDatabase(BeaconScanningService.this.getBaseContext()).beaconMonitoredDao().getAll();
                for (BeaconMonitored beacon : listOfMonitored) {
                    ContextDatabase.getDatabase(BeaconScanningService.this.getBaseContext()).beaconMonitoredDao().delete(beacon);
                    try {
                        if (beacon.getType() == BeaconType.IBeacon) {
                            UUID uuid = UUID.fromString(beacon.getIdentifier());
                            BeaconScanningService.this.mBeaconManager.stopRangingBeaconsInRegion(new Region(beacon.getIdentifier(), Identifier.fromUuid((UUID)uuid), null, null));
                            continue;
                        }
                        if (beacon.getType() != BeaconType.Eddystone) continue;
                        BeaconScanningService.this.mBeaconManager.stopRangingBeaconsInRegion(new Region(beacon.getIdentifier(), Identifier.fromInt((int)Integer.parseInt(beacon.getIdentifier())), null, null));
                    }
                    catch (RemoteException | IllegalArgumentException e) {
                        Logger.exception((String)"BeaconScanningService.GetMonitoredBeacons.onPostExecute_I", (Exception)e);
                    }
                }
                ArrayList<Region> listOfMonitoredRegions = new ArrayList<Region>();
                Result result = FlyAway.get((Context)BeaconScanningService.this.getBaseContext(), (String)BeaconScanningService.API_CONTEXT_BEACONS_GETTOMONITOR, (QueryParameters)new QueryParameters(new QueryBuilder()), (IDeserializer)new DeserializeMonitoredBeacons(), (String)"BeaconScanningService.GetMonitoredBeacons");
                if (result != null && result.getResult() != null && ((PagedResponse)result.getResult()).getItems() != null) {
                    for (BeaconMonitored mb : ((PagedResponse)result.getResult()).getItems()) {
                        try {
                            Region region = null;
                            if (mb.getType() == BeaconType.IBeacon) {
                                UUID uuid = UUID.fromString(mb.getIdentifier());
                                region = new Region(mb.getIdentifier(), Identifier.fromUuid((UUID)uuid), null, null);
                                ContextDatabase.getDatabase(BeaconScanningService.this.getBaseContext()).beaconMonitoredDao().insert(mb);
                            } else if (mb.getType() == BeaconType.Eddystone) {
                                region = new Region(mb.getIdentifier(), Identifier.fromInt((int)Integer.parseInt(mb.getIdentifier())), null, null);
                            }
                            if (region == null) continue;
                            listOfMonitoredRegions.add(region);
                        }
                        catch (IllegalArgumentException e) {
                            Logger.exception((String)"BeaconScanningService.GetMonitoredBeacons.onPostExecute_II", (Exception)e);
                        }
                    }
                }
                return listOfMonitoredRegions;
            }
            catch (FlybitsException | IllegalStateException e) {
                Logger.exception((String)"BeaconScanningService.GetMonitoredBeacons.onPostExecute_III", (Exception)e);
                return null;
            }
        }

        protected void onPostExecute(List<Region> result) {
            super.onPostExecute(result);
            if (result != null && result.size() > 0) {
                BeaconScanningService.this.mBeaconManager.setBackgroundBetweenScanPeriod(10000L);
                BeaconScanningService.this.mBeaconManager.addRangeNotifier((RangeNotifier)BeaconScanningService.this);
                BeaconScanningService.this.regionBootstrap = new RegionBootstrap((BootstrapNotifier)BeaconScanningService.this, result);
                BeaconScanningService.this.backgroundPowerSaver = new BackgroundPowerSaver((Context)BeaconScanningService.this);
            } else {
                BeaconScanningService.this.stopSelf();
            }
        }
    }

    public class UploadBeaconData
    extends AsyncTask<Void, Integer, Void> {
        private BeaconDataList listOfActiveBeacons;

        public UploadBeaconData(List<BeaconActive> beacons) {
            this.listOfActiveBeacons = new BeaconDataList(beacons);
        }

        protected Void doInBackground(Void ... args) {
            this.listOfActiveBeacons.updateNow(BeaconScanningService.this.getBaseContext(), null);
            boolean isSuccessful = ContextManager.flushContextData(BeaconScanningService.this.getBaseContext());
            if (isSuccessful) {
                ContextDatabase.getDatabase(BeaconScanningService.this.getBaseContext()).beaconActiveDao().deleteBeaconsNotInRange();
                Logger.setTag((String)"BeaconScanningService").d("Deleted out of Range Beacons");
            }
            return null;
        }

        protected void onPostExecute(Void result) {
            super.onPostExecute((Object)result);
        }
    }
}

