/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.db.dao;

import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityDeletionOrUpdateAdapter;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.database.Cursor;
import com.flybits.context.db.converters.ServiceTypeConverter;
import com.flybits.context.db.dao.FlybitsContextPluginDAO;
import com.flybits.context.plugins.FlybitsContextPlugin;
import java.util.ArrayList;
import java.util.List;

public class FlybitsContextPluginDAO_Impl
implements FlybitsContextPluginDAO {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfFlybitsContextPlugin;
    private final ServiceTypeConverter __serviceTypeConverter = new ServiceTypeConverter();
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfFlybitsContextPlugin;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfFlybitsContextPlugin;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public FlybitsContextPluginDAO_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfFlybitsContextPlugin = new EntityInsertionAdapter<FlybitsContextPlugin>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `flybits_context_plugin`(`refresh_time_flex`,`refresh_time`,`running`,`service`) VALUES (?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, FlybitsContextPlugin value) {
                stmt.bindLong(1, value.getRefreshTimeFlex());
                stmt.bindLong(2, value.getRefreshTime());
                int _tmp = value.isRunning() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp);
                String _tmp_1 = FlybitsContextPluginDAO_Impl.this.__serviceTypeConverter.toString(value.getService());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
            }
        };
        this.__deletionAdapterOfFlybitsContextPlugin = new EntityDeletionOrUpdateAdapter<FlybitsContextPlugin>(__db){

            public String createQuery() {
                return "DELETE FROM `flybits_context_plugin` WHERE `service` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, FlybitsContextPlugin value) {
                String _tmp = FlybitsContextPluginDAO_Impl.this.__serviceTypeConverter.toString(value.getService());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
            }
        };
        this.__updateAdapterOfFlybitsContextPlugin = new EntityDeletionOrUpdateAdapter<FlybitsContextPlugin>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `flybits_context_plugin` SET `refresh_time_flex` = ?,`refresh_time` = ?,`running` = ?,`service` = ? WHERE `service` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, FlybitsContextPlugin value) {
                stmt.bindLong(1, value.getRefreshTimeFlex());
                stmt.bindLong(2, value.getRefreshTime());
                int _tmp = value.isRunning() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp);
                String _tmp_1 = FlybitsContextPluginDAO_Impl.this.__serviceTypeConverter.toString(value.getService());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                String _tmp_2 = FlybitsContextPluginDAO_Impl.this.__serviceTypeConverter.toString(value.getService());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM flybits_context_plugin";
                return "DELETE FROM flybits_context_plugin";
            }
        };
    }

    @Override
    public void insert(FlybitsContextPlugin flybitsContextPlugin) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfFlybitsContextPlugin.insert((Object)flybitsContextPlugin);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(FlybitsContextPlugin flybitsContextPlugin) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfFlybitsContextPlugin.handle((Object)flybitsContextPlugin);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(FlybitsContextPlugin flybitsContextPlugin) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfFlybitsContextPlugin.handle((Object)flybitsContextPlugin);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FlybitsContextPlugin> getAll() {
        String _sql = "SELECT * FROM flybits_context_plugin";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM flybits_context_plugin", (int)0);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfRefreshTimeFlex = _cursor.getColumnIndexOrThrow("refresh_time_flex");
            int _cursorIndexOfRefreshTime = _cursor.getColumnIndexOrThrow("refresh_time");
            int _cursorIndexOfIsRunning = _cursor.getColumnIndexOrThrow("running");
            int _cursorIndexOfService = _cursor.getColumnIndexOrThrow("service");
            ArrayList<FlybitsContextPlugin> _result = new ArrayList<FlybitsContextPlugin>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpRefreshTimeFlex = _cursor.getLong(_cursorIndexOfRefreshTimeFlex);
                long _tmpRefreshTime = _cursor.getLong(_cursorIndexOfRefreshTime);
                int _tmp = _cursor.getInt(_cursorIndexOfIsRunning);
                boolean _tmpIsRunning = _tmp != 0;
                String _tmp_1 = _cursor.getString(_cursorIndexOfService);
                Class _tmpService = this.__serviceTypeConverter.fromString(_tmp_1);
                FlybitsContextPlugin _item = new FlybitsContextPlugin(_tmpRefreshTimeFlex, _tmpRefreshTime, _tmpIsRunning, _tmpService);
                _result.add(_item);
            }
            ArrayList<FlybitsContextPlugin> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

