package com.flybits.context.plugins.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;

import com.flybits.commons.library.logging.Logger;
import com.flybits.context.models.ContextData;
import com.flybits.context.services.FlybitsContextPluginService;

public class NetworkContextPluginService extends FlybitsContextPluginService {

    private final static String _TAG = "PluginNetwork";

    @Override
    public void initialize(Bundle bundle) {}

    @Override
    public String[] getRequiredPermissions() {
        return new String[]{"android.permission.ACCESS_WIFI_STATE", "android.permission.ACCESS_NETWORK_STATE"};
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public ContextData getData() {
        Logger.setTag(_TAG).d("Fetching Data...");
        ConnectivityManager cm      = (ConnectivityManager) getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo activeNetwork   = cm.getActiveNetworkInfo();
        return new NetworkData(getBaseContext(), activeNetwork);
    }

    @Override
    public void onDestroy() {
        Logger.setTag(_TAG).d("...Destroyed");
        super.onDestroy();
    }

}
