package com.flybits.context.exceptions;

/**
 * The {@code InvalidContextPluginException} is thrown when an invalid
 * {@code ContextPlugin} has been initialized. The following issue could
 * cause an invalid {@code ContextPlugin} to be initialized:
 * <ul>
 *     <li>Unique Plugin Identifier has not been set</li>
 * </ul>
 */
public class InvalidContextPluginException extends RuntimeException{

    /**
     * Constructs a new {@code InvalidContextPluginException} that includes the current
     * stack trace.
     */
    public InvalidContextPluginException(){}

    /**
     * Constructs a new {@code InvalidContextPluginException} with the current stack
     * trace and the specified detail message.
     *
     * @param message the detail message for this exception.
     */
    public InvalidContextPluginException(String message) {
        super(message);
    }

    /**
     * Constructs a new {@code InvalidContextPluginException} with the current stack
     * trace and the specified cause.
     *
     * @param throwable the cause of this exception.
     */
    public InvalidContextPluginException(Throwable throwable){
        super(throwable);
    }

    /**
     * Constructs a new {@code InvalidContextPluginException} with the current stack
     * trace, the specified detail message and the specified cause.
     *
     * @param detailMessage the detail message for this exception.
     * @param throwable the cause of this exception.
     */
    public InvalidContextPluginException(String detailMessage, Throwable throwable){
        super(detailMessage, throwable);
    }
}