package com.flybits.context.deserializations;

import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.models.internal.PagedResponse;
import com.flybits.commons.library.models.internal.Pagination;
import com.flybits.context.models.RuleEvalutated;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

public class DeserializeEvaluatedRules extends IDeserializer<PagedResponse<RuleEvalutated>> {

    @Override
    public String toJson(PagedResponse<RuleEvalutated> obj) {

        if (obj == null || obj.getItems() == null || obj.getItems().size() == 0){
            return "[]";
        }

        JSONArray array = new JSONArray();
        for (RuleEvalutated rule : obj.getItems()){
            JSONObject object = new JSONObject();
            try{
                object.put("id", rule.getId());
            }catch(JSONException e){}
            try{
                object.put("name", rule.getName());
            }catch(JSONException e){}
            try{
                object.put("lastEvaluated", rule.getEvaluatedTime());
            }catch(JSONException e){}
            try{
                object.put("lastResult", rule.isLastResult());
            }catch(JSONException e){}
            array.put(object);
        }
        return array.toString();
    }

    @Override
    public PagedResponse<RuleEvalutated> fromJson(JSONObject jsonObject) {
        return null;
    }

    @Override
    public PagedResponse<RuleEvalutated> fromJson(JSONArray jsonArray) {
        try {
            ArrayList<RuleEvalutated> rules = new ArrayList<>();

            for(int i = 0; i < jsonArray.length(); i++)
            {
                JSONObject elementObj = jsonArray.getJSONObject(i);

                String id = null, name = null, data = null;
                boolean lastResult = false;
                long timestamp = -1;

                if (!elementObj.isNull("id")){
                    id           = elementObj.getString("id");
                }
                if (!elementObj.isNull("name")){
                    name           = elementObj.getString("name");
                }
                if (!elementObj.isNull("lastEvaluated")){
                    timestamp           = elementObj.getLong("lastEvaluated");
                }
                if (!elementObj.isNull("lastResult")){
                    lastResult           = elementObj.getBoolean("lastResult");
                }
                if (!elementObj.isNull("data")){
                    Object jsonType = elementObj.get("data");
                    if (jsonType instanceof JSONObject) {
                        data = elementObj.getJSONObject("data").toString();
                    }else if (jsonType instanceof JSONArray){
                        data = elementObj.getJSONArray("data").toString();
                    }else{
                        data = elementObj.getString("data");
                    }
                }
                rules.add(new RuleEvalutated(id, timestamp, lastResult, name, data));
            }
            return new PagedResponse<RuleEvalutated>(rules, new Pagination(jsonArray.length(), 0, jsonArray.length()));
        }catch (JSONException | NullPointerException e){
            return null;
        }
    }
}
