package com.flybits.context.db.dao;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Delete;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.OnConflictStrategy;
import android.arch.persistence.room.Query;
import android.arch.persistence.room.Update;

import com.flybits.context.models.internal.Plugin;

import java.util.List;

@Dao
public interface DBPluginDAO {

    @Query("Select * from plugin")
    List<Plugin> getAll();

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(Plugin... plugins);

    @Delete
    void delete(Plugin plugin);

    @Update
    void update(Plugin... plugin);

    @Query("DELETE FROM plugin")
    void deleteAll();

}
