package com.flybits.context;

public enum ReservedContextPlugin {

    /**
     * Indicates that activity the user is currently performing.
     */
    ACTIVITY("ctx.sdk.activity"),

    /**
     * Indicates the battery life (as a percentage) should be obtained from the context sensors.
     */
    BATTERY("ctx.sdk.battery"),

    /**
     * Indicates that beacons should be used to obtain the user's location.
     */
    BEACON("ctx.sdk.beacon"),

    /**
     * Indicates SIM Card carrier information should be obtained from the SIM card.
     */
    CARRIER( "ctx.sdk.carrier"),

    /**
     * Indicates that the step counter should used to retrieve context information from the sensors.
     */
    FITNESS( "ctx.sdk.fitness"),

    /**
     * Indicates that the language
     */
    LANGUAGE( "ctx.sdk.device"),

    /**
     * Indicates that the location of the device should be obtained from the context sensors.
     */
    LOCATION("ctx.sdk.location"),

    /**
     * An extension of the location plugin, that updates location data at a lower pace for weather processing.
     */
    WEATHER("ctx.sdk.weather"),

    /**
     * Indicates the availability of the Internet connection and whether or not it is present.
     */
    NETWORK_CONNECTIVITY("ctx.sdk.network"),

    /**
     * Indicates that the Context Plugin with this particular id is not supported.
     */
    NOT_SUPPORTED("not_supported");


    private final String value;

    /**
     * Constructor that defines the key for each {@code AvailablePlugins} option.
     *
     * @param value The String value representing each {@code AvailablePlugins} option.
     */
    ReservedContextPlugin(String value) {
        this.value      = value;
    }

    /**
     * Get the String representation for the {@code AvailablePlugins} option.
     *
     * @return String representation of the {@code AvailablePlugins} option.
     */
    public String getKey() {
        return this.value;
    }

    /**
     * Get the {@code AvailablePlugins} enum value corresponding to an integer representation.
     *
     * @param key the String representation of the {@code AvailablePlugins} enum.
     *
     * @return The {@code AvailablePlugins} enum for the integer representation.
     */
    public static ReservedContextPlugin fromKey(String key) {
        for(ReservedContextPlugin type : ReservedContextPlugin.values()) {
            if(type.getKey().equalsIgnoreCase(key)) {
                return type;
            }
        }
        return NOT_SUPPORTED;
    }

}
