/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.models;

import android.support.annotation.Nullable;
import android.util.Base64;
import com.google.android.gms.maps.model.LatLng;
import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RulePredicate {
    private static final double EARTH_RADIUS = 6371009.0;
    private String predicate;
    private HashMap<String, String> pluginData;

    private RulePredicate(String value) {
        this.predicate = value;
        this.pluginData = new HashMap();
    }

    public String getString() {
        return this.predicate;
    }

    public HashMap<String, String> getPluginData() {
        return this.pluginData;
    }

    public void addPluginData(String key, String value) {
        if (this.pluginData == null) {
            this.pluginData = new HashMap();
        }
        this.pluginData.put(key, value);
    }

    public static RulePredicate greaterThan(String plugin, int value) {
        return new RulePredicate("gr(" + plugin + "," + value + ")");
    }

    public static RulePredicate greaterThan(String plugin, int value, String id2) throws IllegalArgumentException {
        String predicate = RulePredicate.getQueryParam(plugin, id2);
        if (predicate != null) {
            return RulePredicate.greaterThan(predicate, value);
        }
        throw new IllegalArgumentException("You plugin must be in the following format: w.x.y.z where the combination of w.x.y.z indicate the plugin identifier that should be evaluated.");
    }

    public static RulePredicate greaterThanOrEqual(String plugin, int value) {
        return new RulePredicate("greq(" + plugin + "," + value + ")");
    }

    public static RulePredicate greaterThanOrEqual(String plugin, int value, String id2) throws IllegalArgumentException {
        String predicate = RulePredicate.getQueryParam(plugin, id2);
        if (predicate != null) {
            return RulePredicate.greaterThanOrEqual(predicate, value);
        }
        throw new IllegalArgumentException("You plugin must be in the following format: w.x.y.z where the combination of w.x.y.z indicate the plugin identifier that should be evaluated.");
    }

    public static RulePredicate lessThan(String plugin, int value) {
        return new RulePredicate("ls(" + plugin + "," + value + ")");
    }

    public static RulePredicate lessThan(String plugin, int value, String id2) throws IllegalArgumentException {
        String predicate = RulePredicate.getQueryParam(plugin, id2);
        if (predicate != null) {
            return RulePredicate.lessThan(predicate, value);
        }
        throw new IllegalArgumentException("You plugin must be in the following format: w.x.y.z where the combination of w.x.y.z indicate the plugin identifier that should be evaluated.");
    }

    public static RulePredicate lessThanOrEqual(String plugin, int value) {
        return new RulePredicate("lseq(" + plugin + "," + value + ")");
    }

    public static RulePredicate lessThanOrEqual(String plugin, int value, String id2) throws IllegalArgumentException {
        String predicate = RulePredicate.getQueryParam(plugin, id2);
        if (predicate != null) {
            return RulePredicate.lessThanOrEqual(predicate, value);
        }
        throw new IllegalArgumentException("You plugin must be in the following format: w.x.y.z where the combination of w.x.y.z indicate the plugin identifier that should be evaluated.");
    }

    public static RulePredicate equals(String plugin, int value) {
        return new RulePredicate("eq(" + plugin + "," + value + ")");
    }

    public static RulePredicate equals(String plugin, int value, String id2) throws IllegalArgumentException {
        String predicate = RulePredicate.getQueryParam(plugin, id2);
        if (predicate != null) {
            return RulePredicate.equals(predicate, value);
        }
        throw new IllegalArgumentException("You plugin must be in the following format: w.x.y.z where the combination of w.x.y.z indicate the plugin identifier that should be evaluated.");
    }

    public static RulePredicate notEquals(String plugin, int value) {
        return new RulePredicate("neq(" + plugin + "," + value + ")");
    }

    public static RulePredicate notEquals(String plugin, int value, String id2) throws IllegalArgumentException {
        String predicate = RulePredicate.getQueryParam(plugin, id2);
        if (predicate != null) {
            return RulePredicate.notEquals(predicate, value);
        }
        throw new IllegalArgumentException("You plugin must be in the following format: w.x.y.z where the combination of w.x.y.z indicate the plugin identifier that should be evaluated.");
    }

    public static RulePredicate equals(String plugin, boolean value) {
        return new RulePredicate("boolEq(" + plugin + "," + value + ")");
    }

    public static RulePredicate equals(String plugin, boolean value, String id2) throws IllegalArgumentException {
        String predicate = RulePredicate.getQueryParam(plugin, id2);
        if (predicate != null) {
            return RulePredicate.equals(predicate, value);
        }
        throw new IllegalArgumentException("You plugin must be in the following format: w.x.y.z where the combination of w.x.y.z indicate the plugin identifier that should be evaluated.");
    }

    public static RulePredicate notEquals(String plugin, boolean value) {
        return new RulePredicate("boolNeq(" + plugin + "," + value + ")");
    }

    public static RulePredicate notEquals(String plugin, boolean value, String id2) throws IllegalArgumentException {
        String predicate = RulePredicate.getQueryParam(plugin, id2);
        if (predicate != null) {
            return RulePredicate.notEquals(predicate, value);
        }
        throw new IllegalArgumentException("You plugin must be in the following format: w.x.y.z where the combination of w.x.y.z indicate the plugin identifier that should be evaluated.");
    }

    public static RulePredicate equals(String plugin, String value) {
        return new RulePredicate("stringEq(" + plugin + ",'" + value + "')");
    }

    public static RulePredicate equals(String plugin, String value, String id2) throws IllegalArgumentException {
        String predicate = RulePredicate.getQueryParam(plugin, id2);
        if (predicate != null) {
            return RulePredicate.equals(predicate, value);
        }
        throw new IllegalArgumentException("You plugin must be in the following format: w.x.y.z where the combination of w.x.y.z indicate the plugin identifier that should be evaluated.");
    }

    public static RulePredicate equalsIgnoreCase(String plugin, String value) {
        return new RulePredicate("stringFoldEq(" + plugin + ",'" + value + "')");
    }

    public static RulePredicate equalsIgnoreCase(String plugin, String value, String id2) throws IllegalArgumentException {
        String predicate = RulePredicate.getQueryParam(plugin, id2);
        if (predicate != null) {
            return RulePredicate.equalsIgnoreCase(predicate, value);
        }
        throw new IllegalArgumentException("You plugin must be in the following format: w.x.y.z where the combination of w.x.y.z indicate the plugin identifier that should be evaluated.");
    }

    public static RulePredicate notEquals(String plugin, String value) {
        return new RulePredicate("stringNeq(" + plugin + ",'" + value + "')");
    }

    public static RulePredicate notEquals(String plugin, String value, String id2) throws IllegalArgumentException {
        String predicate = RulePredicate.getQueryParam(plugin, id2);
        if (predicate != null) {
            return RulePredicate.notEquals(predicate, value);
        }
        throw new IllegalArgumentException("You plugin must be in the following format: w.x.y.z where the combination of w.x.y.z indicate the plugin identifier that should be evaluated.");
    }

    public static RulePredicate notEqualsIgnoreCase(String plugin, String value) {
        return new RulePredicate("stringFoldNeq(" + plugin + ",'" + value + "')");
    }

    public static RulePredicate notEqualsIgnoreCase(String plugin, String value, String id2) throws IllegalArgumentException {
        String predicate = RulePredicate.getQueryParam(plugin, id2);
        if (predicate != null) {
            return RulePredicate.notEqualsIgnoreCase(predicate, value);
        }
        throw new IllegalArgumentException("You plugin must be in the following format: w.x.y.z where the combination of w.x.y.z indicate the plugin identifier that should be evaluated.");
    }

    public static RulePredicate contains(String plugin, String value) {
        return new RulePredicate("stringContains(" + plugin + ",'" + value + "')");
    }

    public static RulePredicate contains(String plugin, String value, String id2) throws IllegalArgumentException {
        String predicate = RulePredicate.getQueryParam(plugin, id2);
        if (predicate != null) {
            return RulePredicate.contains(predicate, value);
        }
        throw new IllegalArgumentException("You plugin must be in the following format: w.x.y.z where the combination of w.x.y.z indicate the plugin identifier that should be evaluated.");
    }

    public static RulePredicate containsIgnoreCase(String plugin, String value) {
        return new RulePredicate("stringFoldContains(" + plugin + ",'" + value + "')");
    }

    public static RulePredicate containsIgnoreCase(String plugin, String value, String id2) throws IllegalArgumentException {
        String predicate = RulePredicate.getQueryParam(plugin, id2);
        if (predicate != null) {
            return RulePredicate.containsIgnoreCase(predicate, value);
        }
        throw new IllegalArgumentException("You plugin must be in the following format: w.x.y.z where the combination of w.x.y.z indicate the plugin identifier that should be evaluated.");
    }

    @Nullable
    public static RulePredicate withinRange(double pointLat, double pointLng, int distanceInMeters, boolean inArea) {
        try {
            String encodedBase64DataForLocation = RulePredicate.encodePoints(pointLat, pointLng, distanceInMeters);
            UUID randomGUID = UUID.randomUUID();
            String guidAsString = randomGUID.toString().toUpperCase();
            RulePredicate predicate = RulePredicate.equals("ctx.flybits.area.query.inArea." + guidAsString, inArea);
            predicate.addPluginData("ctx.flybits.area.query.inArea." + guidAsString, encodedBase64DataForLocation);
            return predicate;
        }
        catch (UnsupportedEncodingException | JSONException e) {
            return null;
        }
    }

    private static String getQueryParam(String plugin, String id2) throws InvalidParameterException {
        try {
            String[] result = plugin.split("\\.");
            int index = plugin.lastIndexOf(".");
            if (result.length == 4) {
                return plugin.substring(0, index) + ".query." + result[result.length - 1] + "." + id2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String encodePoints(double pointLat, double pointLng, int distanceInMeters) throws UnsupportedEncodingException, JSONException {
        LatLng myLatLng = new LatLng(pointLat, pointLng);
        LatLng topLeft = RulePredicate.computeOffset(myLatLng, distanceInMeters, 315.0);
        LatLng topRight = RulePredicate.computeOffset(myLatLng, distanceInMeters, 45.0);
        LatLng bottomRight = RulePredicate.computeOffset(myLatLng, distanceInMeters, 135.0);
        LatLng bottomLeft = RulePredicate.computeOffset(myLatLng, distanceInMeters, 225.0);
        JSONObject latlng1 = new JSONObject();
        latlng1.put("lat", topLeft.latitude);
        latlng1.put("lng", topLeft.longitude);
        JSONObject latlng2 = new JSONObject();
        latlng2.put("lat", topRight.latitude);
        latlng2.put("lng", topRight.longitude);
        JSONObject latlng3 = new JSONObject();
        latlng3.put("lat", bottomRight.latitude);
        latlng3.put("lng", bottomRight.longitude);
        JSONObject latlng4 = new JSONObject();
        latlng4.put("lat", bottomLeft.latitude);
        latlng4.put("lng", bottomLeft.longitude);
        JSONArray shapes = new JSONArray();
        shapes.put((Object)latlng1);
        shapes.put((Object)latlng2);
        shapes.put((Object)latlng3);
        shapes.put((Object)latlng4);
        shapes.put((Object)latlng1);
        JSONArray area = new JSONArray();
        area.put((Object)shapes);
        JSONObject multipleShapes = new JSONObject();
        multipleShapes.put("shapes", (Object)area);
        JSONObject object = new JSONObject();
        object.put("area", (Object)multipleShapes);
        byte[] data = object.toString().getBytes("UTF-8");
        return Base64.encodeToString((byte[])data, (int)2);
    }

    private static LatLng computeOffset(LatLng from, double distance, double heading) {
        heading = Math.toRadians(heading);
        double fromLat = Math.toRadians(from.latitude);
        double fromLng = Math.toRadians(from.longitude);
        double cosDistance = Math.cos(distance /= 6371009.0);
        double sinDistance = Math.sin(distance);
        double sinFromLat = Math.sin(fromLat);
        double cosFromLat = Math.cos(fromLat);
        double sinLat = cosDistance * sinFromLat + sinDistance * cosFromLat * Math.cos(heading);
        double dLng = Math.atan2(sinDistance * cosFromLat * Math.sin(heading), cosDistance - sinFromLat * sinLat);
        return new LatLng(Math.toDegrees(Math.asin(sinLat)), Math.toDegrees(fromLng + dLng));
    }
}

