/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.fitness;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.models.ContextData;
import com.flybits.context.plugins.fitness.FitnessData;
import com.flybits.context.plugins.fitness.FitnessUtils;
import com.flybits.context.plugins.fitness.IFitnessData;
import com.flybits.context.services.FlybitsContextPluginService;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.fitness.Fitness;
import java.util.concurrent.TimeUnit;

public class FitnessContextPluginService
extends FlybitsContextPluginService
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
IFitnessData {
    private GoogleApiClient mGoogleApiClient;
    private static final String _TAG = "PluginFitness";

    @Override
    public void initialize(Bundle bundle) {
        if (this.mGoogleApiClient == null) {
            this.mGoogleApiClient = new GoogleApiClient.Builder((Context)this).addApi(Fitness.HISTORY_API).addScope(new Scope("https://www.googleapis.com/auth/fitness.activity.write")).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
        }
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public ContextData getData() {
        Logger.setTag((String)_TAG).d("Fetching Data ...");
        if (this.mGoogleApiClient != null) {
            if (!this.mGoogleApiClient.isConnected()) {
                this.mGoogleApiClient.blockingConnect(10L, TimeUnit.SECONDS);
            }
            if (this.mGoogleApiClient.isConnected()) {
                FitnessUtils.getStepsToday(this.mGoogleApiClient, this);
            }
        }
        this.wait(5L, TimeUnit.SECONDS);
        return null;
    }

    public void onConnected(@Nullable Bundle bundle) {
        Logger.setTag((String)_TAG).d("GoogleAPIClient: onConnected");
    }

    public void onConnectionSuspended(int i) {
        Logger.setTag((String)_TAG).w("GoogleAPIClient: onConnectionSuspended: " + i);
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Logger.setTag((String)_TAG).e("GoogleAPIClient: onConnectionFailed: + " + connectionResult);
    }

    @Override
    public void onDestroy() {
        Logger.setTag((String)_TAG).d("...Destroyed");
        if (this.mGoogleApiClient != null && this.mGoogleApiClient.isConnected()) {
            this.mGoogleApiClient.disconnect();
        }
        super.onDestroy();
    }

    @Override
    public void onGetSteps(long steps) {
        FitnessData data = new FitnessData(steps);
        long timeInSec = data.getTime() > 0L ? data.getTime() : System.currentTimeMillis() / 1000L;
        data.update(this.getBaseContext(), timeInSec, null);
    }

    @Override
    public void onCancel() {
    }

    @Override
    public String[] getRequiredPermissions() {
        return new String[0];
    }
}

