/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.fitness;

import android.support.annotation.NonNull;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.plugins.fitness.IFitnessData;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.fitness.Fitness;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.DataReadResult;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

class FitnessUtils {
    static final String _TAG = "FitnessData";

    FitnessUtils() {
    }

    static void getStepsToday(GoogleApiClient client, IFitnessData callback) {
        Calendar calStart = Calendar.getInstance();
        Calendar calEnd = Calendar.getInstance();
        Date now = new Date();
        calStart.setTime(now);
        calStart.set(11, 0);
        calStart.set(12, 0);
        calStart.set(13, 1);
        FitnessUtils.getSteps(calStart.getTimeInMillis(), calEnd.getTimeInMillis(), client, callback);
    }

    static void getSteps(long startTime, long endTime, GoogleApiClient client, final IFitnessData callback) {
        DataReadRequest readRequest = new DataReadRequest.Builder().aggregate(DataType.TYPE_STEP_COUNT_DELTA, DataType.AGGREGATE_STEP_COUNT_DELTA).bucketByTime(1, TimeUnit.DAYS).setTimeRange(startTime, endTime, TimeUnit.MILLISECONDS).build();
        Fitness.HistoryApi.readData(client, readRequest).setResultCallback((ResultCallback)new ResultCallback<DataReadResult>(){

            public void onResult(@NonNull DataReadResult dataReadResult) {
                int steps = FitnessUtils.getSteps(dataReadResult);
                if (steps == -1) {
                    callback.onCancel();
                } else {
                    callback.onGetSteps(steps);
                }
            }
        });
    }

    static int getSteps(DataReadResult dataReadResult) {
        int addition = 0;
        if (dataReadResult.getBuckets() == null || dataReadResult.getBuckets().size() == 0) {
            return -1;
        }
        for (Bucket bucket : dataReadResult.getBuckets()) {
            if (bucket.getDataSets().size() == 0) {
                return -1;
            }
            for (DataSet dataSet : bucket.getDataSets()) {
                if (dataSet.getDataPoints().size() == 0) {
                    return -1;
                }
                for (DataPoint point : dataSet.getDataPoints()) {
                    try {
                        addition += point.getValue(Field.FIELD_STEPS).asInt();
                    }
                    catch (Exception e) {
                        Logger.exception((String)"FitnessUtils.getSteps", (Exception)e);
                    }
                }
            }
        }
        Logger.setTag((String)_TAG).d("Number Of Steps: " + addition);
        return 0;
    }
}

