/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.beacon;

import android.os.Parcel;
import android.os.Parcelable;
import com.flybits.context.models.ContextData;
import com.flybits.context.plugins.beacon.BeaconActive;
import com.flybits.context.plugins.beacon.BeaconType;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BeaconDataList
extends ContextData
implements Parcelable {
    private List<BeaconActive> data;
    public static final Parcelable.Creator<BeaconDataList> CREATOR = new Parcelable.Creator<BeaconDataList>(){

        public BeaconDataList createFromParcel(Parcel in) {
            return new BeaconDataList(in);
        }

        public BeaconDataList[] newArray(int size) {
            return new BeaconDataList[size];
        }
    };

    public BeaconDataList() {
    }

    protected BeaconDataList(Parcel in) {
        this.data = new ArrayList<BeaconActive>();
        in.readTypedList(this.data, BeaconActive.CREATOR);
        this.setTime(in.readLong());
    }

    public BeaconDataList(List<BeaconActive> list) {
        this.data = list;
    }

    public List<BeaconActive> getData() {
        return this.data;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BeaconDataList) {
            BeaconDataList that = (BeaconDataList)o;
            if (that.data == null && this.data == null) {
                return true;
            }
            if (that.data != null && this.data == null || that.data == null && this.data != null) {
                return false;
            }
            return that.data.equals(this.data);
        }
        return false;
    }

    @Override
    public void fromJson(String json) {
        this.data = new ArrayList<BeaconActive>();
        try {
            JSONArray jArr = new JSONArray(json);
            for (int i = 0; i < jArr.length(); ++i) {
                JSONObject elementObj = jArr.getJSONObject(i);
                BeaconActive activeBeacon = new BeaconActive(BeaconType.IBeacon, "id1", "id2", "id3", 1L);
                activeBeacon.fromJson(elementObj.toString());
                this.data.add(activeBeacon);
            }
        }
        catch (NullPointerException | JSONException throwable) {
            // empty catch block
        }
    }

    @Override
    public String getPluginID() {
        return "ctx.sdk.beacon";
    }

    @Override
    public String toJson() {
        String jsonToSend = "[";
        for (int i = 0; i < this.data.size(); ++i) {
            jsonToSend = jsonToSend + this.data.get(i);
            if (i >= this.data.size() - 1) continue;
            jsonToSend = jsonToSend + ",";
        }
        jsonToSend = jsonToSend + "]";
        return jsonToSend;
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedList(this.data);
        dest.writeLong(this.getTime());
    }
}

