/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.models;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.PrimaryKey;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.context.deserializations.DeserializeEvaluatedRules;
import com.flybits.context.models.results.RulesEvaluatedResult;
import com.flybits.context.utils.RulesQueryParameters;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Entity(tableName="ruleEvaluations")
public class RuleEvalutated
implements Parcelable {
    public static final String API = "/context/rules/evaluations";
    @PrimaryKey
    @ColumnInfo(name="ruleEvaluationID")
    @NonNull
    private String id;
    @ColumnInfo(name="name")
    private String name;
    @ColumnInfo(name="isLastResult")
    private boolean lastResult;
    @Ignore
    private String dataAsString;
    @Ignore
    private long evaluatedAt;
    public static final Parcelable.Creator<RuleEvalutated> CREATOR = new Parcelable.Creator<RuleEvalutated>(){

        public RuleEvalutated createFromParcel(Parcel in) {
            return new RuleEvalutated(in);
        }

        public RuleEvalutated[] newArray(int size) {
            return new RuleEvalutated[size];
        }
    };

    public RuleEvalutated() {
    }

    @Ignore
    public RuleEvalutated(String id2, String name, boolean lastResult) {
        this.id = id2;
        this.lastResult = lastResult;
        this.name = name;
    }

    @Ignore
    public RuleEvalutated(String id2, long lastEvaluated, boolean lastResult, String name, String dataAsString) {
        this(id2, name, lastResult);
        this.evaluatedAt = lastEvaluated;
        this.dataAsString = dataAsString;
    }

    @Ignore
    public RuleEvalutated(Parcel in) {
        this.id = in.readString();
        this.evaluatedAt = in.readLong();
        this.lastResult = in.readInt() == 1;
        this.name = in.readString();
        this.dataAsString = in.readString();
    }

    public String getDataAsString() {
        return this.dataAsString;
    }

    public long getEvaluatedTime() {
        return this.evaluatedAt;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLastResult() {
        return this.lastResult;
    }

    public void setId(String id2) {
        this.id = id2;
    }

    public void setLastResult(boolean lastResult) {
        this.lastResult = lastResult;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleEvalutated rule = (RuleEvalutated)o;
        return !(this.id == null ? rule.id != null : !this.id.equals(rule.id));
    }

    public String toString() {
        return "[ " + this.id + ", " + this.name + " : " + this.lastResult + " ]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.id);
        out.writeLong(this.evaluatedAt);
        out.writeInt(this.lastResult ? 1 : 0);
        out.writeString(this.name);
        out.writeString(this.dataAsString);
    }

    public static RulesEvaluatedResult get(final Context mContext, final RulesQueryParameters params, PagedResultCallback<RuleEvalutated> callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final RulesEvaluatedResult result = new RulesEvaluatedResult(mContext, params, callback, executorService, handler);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Result getRules = FlyAway.get((Context)mContext, (String)RuleEvalutated.API, (QueryParameters)params, (IDeserializer)new DeserializeEvaluatedRules(), (String)"RuleEvaluated.get");
                    result.setResult(getRules);
                }
                catch (FlybitsException e) {
                    result.setResult(new Result(e, "RuleEvaluated.get() failed"));
                }
            }
        });
        return result;
    }
}

