package com.flybits.context.plugins

import android.content.Context

/**
 * The `ContextPlugin` interface is responsible for providing the necessary methods needed to
 * create a valid Flybits Context Plugin. A Context Plugin is responsible for retrieving information
 * about a specific entity whether it's a sensor or 3rd party service.
 */
internal interface ContextPlugin {

    /**
     * Start the `ContextPlugin` and initialize all the variables that are needed for the
     * `ContextPlugin` for successfully start collecting data.
     * TODO: @params
     */
    fun onStart(context: Context)

    /**
     * Stop the `ContextPlugin` and destroy all the variables that are no longer needed aa the
     * `ContextPlugin` is now being deactivated.
     * TODO: @params
     */
    fun onStop(context: Context)

    /**
     * If available, refresh the sensor/3rd party data immediately without having to wait for the
     * regular time interval.
     * TODO: @params
     */
    fun onRefresh(context: Context)

}
