/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.utils;

import com.flybits.commons.library.models.internal.QueryBuilder;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.context.models.RuleScope;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Map;

public class RulesQueryParameters
extends QueryParameters {
    private String scope;

    private RulesQueryParameters(Builder builder) {
        super((QueryBuilder)builder);
        if (builder.scope != null) {
            this.scope = builder.scope;
        }
    }

    public Map<String, ArrayList<String>> getQueryParams() {
        Map params = super.getQueryParams();
        if (this.scope != null) {
            ArrayList<String> listOfScopes = new ArrayList<String>();
            listOfScopes.add(this.scope);
            params.put("scope", listOfScopes);
        }
        return params;
    }

    public static class Builder
    extends QueryBuilder<Builder> {
        private String scope;

        public Builder setScope(RuleScope scope) throws InvalidParameterException {
            if (scope == RuleScope.UNKNOWN) {
                throw new InvalidParameterException("Your Scope must be either User or Project");
            }
            this.scope = scope.getKey();
            return this;
        }

        public RulesQueryParameters build() {
            return new RulesQueryParameters(this);
        }
    }
}

