/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.utils;

import android.support.annotation.Nullable;
import java.util.Calendar;
import org.json.JSONException;
import org.json.JSONObject;

public class RuleScheduler {
    private long startTime;
    private long endTime = -1L;
    private RepeatSchedule repeat;
    private String contextualStart = null;

    public RuleScheduler(Calendar calendar, RepeatSchedule repeat) {
        this.startTime = calendar.getTimeInMillis() / 1000L;
        this.repeat = repeat;
    }

    public RuleScheduler(Calendar calendar) {
        this(calendar, new RepeatSchedule(RepeatSchedule.FrequencyType.ONCE, 1L, 1L));
    }

    public void setEndTime(Calendar calendar) {
        this.endTime = calendar.getTimeInMillis() / 1000L;
    }

    @Nullable
    public JSONObject toJSONObject() {
        try {
            JSONObject object = new JSONObject();
            JSONObject startObject = new JSONObject();
            startObject.put("start", this.startTime);
            startObject.put("repeat", (Object)this.repeat.toJSONObject());
            if (this.contextualStart != null) {
                startObject.put("contextualStart", (Object)this.contextualStart);
            }
            object.put("startScheduler", (Object)startObject);
            if (this.endTime > -1L) {
                JSONObject endObject = new JSONObject();
                endObject.put("start", this.endTime);
                endObject.put("repeat", (Object)this.repeat.toJSONObject());
                object.put("endScheduler", (Object)endObject);
            }
            return object;
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Nullable
    public String toString() {
        return this.toJSONObject().toString();
    }

    public static class RepeatSchedule {
        private long frequency;
        private long limit;
        private FrequencyType type;

        public RepeatSchedule(FrequencyType type, long frequency, long limit) {
            if (type != null) {
                this.type = type;
                this.frequency = frequency;
                this.limit = limit;
            } else {
                this.type = FrequencyType.ONCE;
                this.frequency = 0L;
                this.limit = -1L;
            }
        }

        @Nullable
        public JSONObject toJSONObject() {
            try {
                JSONObject object = new JSONObject();
                object.put("frequencyType", (Object)this.type.getKey());
                object.put("frequency", this.frequency);
                object.put("limit", this.limit);
                return object;
            }
            catch (JSONException e) {
                return null;
            }
        }

        public static enum FrequencyType {
            ONCE("once"),
            HOURLY("hour"),
            DAILY("day"),
            WEEKLY("week"),
            MONTHLY("month"),
            YEARLY("year");

            private final String key;

            private FrequencyType(String key) {
                this.key = key;
            }

            public String getKey() {
                return this.key;
            }

            public static FrequencyType fromKey(String key) {
                for (FrequencyType type : FrequencyType.values()) {
                    if (!type.getKey().equals(key)) continue;
                    return type;
                }
                return ONCE;
            }
        }
    }
}

