/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.weather;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.plugins.location.LocationContextPluginService;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;

public class WeatherContextPluginService
extends LocationContextPluginService
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener {
    private LocationRequest mLocationRequest;
    private static final String _TAG = "PluginWeather";
    private long minDisplacement = -1L;

    @Override
    public void initialize(Bundle bundle) {
        super.initialize(bundle);
        if (bundle != null && bundle.containsKey("minDisplacement")) {
            this.minDisplacement = bundle.getLong("minDisplacement");
        }
    }

    @Override
    public boolean isSupported() {
        return Build.VERSION.SDK_INT < 23 || ContextCompat.checkSelfPermission((Context)this.getBaseContext(), (String)"android.permission.ACCESS_COARSE_LOCATION") == 0;
    }

    @Override
    public void onConnected(@Nullable Bundle bundle) {
        if (this.isSupported()) {
            Logger.setTag((String)_TAG).d("Google API Services connected!");
            this.mLocationRequest = LocationRequest.create().setPriority(105).setInterval(this.getRefreshTime() * 1000L);
            if (this.minDisplacement > 10L) {
                this.mLocationRequest.setSmallestDisplacement((float)this.minDisplacement);
            }
            LocationServices.FusedLocationApi.requestLocationUpdates(this.getGoogleApiClient(), this.mLocationRequest, (LocationListener)this);
        }
    }
}

