/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.db;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.db.SupportSQLiteOpenHelper;
import android.arch.persistence.room.DatabaseConfiguration;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomOpenHelper;
import android.arch.persistence.room.util.TableInfo;
import android.content.Context;
import com.flybits.context.db.ContextDatabase;
import com.flybits.context.db.dao.BasicDataDAO;
import com.flybits.context.db.dao.BasicDataDAO_Impl;
import com.flybits.context.db.dao.BeaconActiveDAO;
import com.flybits.context.db.dao.BeaconActiveDAO_Impl;
import com.flybits.context.db.dao.BeaconMonitoredDAO;
import com.flybits.context.db.dao.BeaconMonitoredDAO_Impl;
import com.flybits.context.db.dao.DBPluginDAO;
import com.flybits.context.db.dao.DBPluginDAO_Impl;
import com.flybits.context.db.dao.RuleEvaluationDAO;
import com.flybits.context.db.dao.RuleEvaluationDAO_Impl;
import java.util.HashMap;
import java.util.HashSet;

public class ContextDatabase_Impl
extends ContextDatabase {
    private volatile DBPluginDAO _dBPluginDAO;
    private volatile RuleEvaluationDAO _ruleEvaluationDAO;
    private volatile BasicDataDAO _basicDataDAO;
    private volatile BeaconActiveDAO _beaconActiveDAO;
    private volatile BeaconMonitoredDAO _beaconMonitoredDAO;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(2){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `plugin` (`contextID` TEXT NOT NULL, `refreshTime` INTEGER NOT NULL, `isSupported` INTEGER NOT NULL, `className` TEXT, `isEnabled` INTEGER NOT NULL, PRIMARY KEY(`contextID`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `ruleEvaluations` (`ruleEvaluationID` TEXT NOT NULL, `name` TEXT, `isLastResult` INTEGER NOT NULL, PRIMARY KEY(`ruleEvaluationID`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `contextData` (`contextID` TEXT NOT NULL, `isSent` INTEGER NOT NULL, `lastUpdated` INTEGER NOT NULL, `data` TEXT, PRIMARY KEY(`contextID`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `beaconsActive` (`id1` TEXT, `id2` TEXT, `id3` TEXT, `type` TEXT, `lastSeen` INTEGER NOT NULL, `isSent` INTEGER NOT NULL, `isInRange` INTEGER NOT NULL, `id` TEXT NOT NULL, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `beaconsMonitored` (`type` TEXT, `uuid` TEXT NOT NULL, PRIMARY KEY(`uuid`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, \"bd8edc5b9768651eb1d6283992b9e605\")");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `plugin`");
                _db.execSQL("DROP TABLE IF EXISTS `ruleEvaluations`");
                _db.execSQL("DROP TABLE IF EXISTS `contextData`");
                _db.execSQL("DROP TABLE IF EXISTS `beaconsActive`");
                _db.execSQL("DROP TABLE IF EXISTS `beaconsMonitored`");
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (ContextDatabase_Impl.this.mCallbacks != null) {
                    int _size = ContextDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)ContextDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                ContextDatabase_Impl.this.mDatabase = _db;
                ContextDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (ContextDatabase_Impl.this.mCallbacks != null) {
                    int _size = ContextDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)ContextDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            protected void validateMigration(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsPlugin = new HashMap<String, TableInfo.Column>(5);
                _columnsPlugin.put("contextID", new TableInfo.Column("contextID", "TEXT", true, 1));
                _columnsPlugin.put("refreshTime", new TableInfo.Column("refreshTime", "INTEGER", true, 0));
                _columnsPlugin.put("isSupported", new TableInfo.Column("isSupported", "INTEGER", true, 0));
                _columnsPlugin.put("className", new TableInfo.Column("className", "TEXT", false, 0));
                _columnsPlugin.put("isEnabled", new TableInfo.Column("isEnabled", "INTEGER", true, 0));
                HashSet _foreignKeysPlugin = new HashSet(0);
                HashSet _indicesPlugin = new HashSet(0);
                TableInfo _infoPlugin = new TableInfo("plugin", _columnsPlugin, _foreignKeysPlugin, _indicesPlugin);
                TableInfo _existingPlugin = TableInfo.read((SupportSQLiteDatabase)_db, (String)"plugin");
                if (!_infoPlugin.equals((Object)_existingPlugin)) {
                    throw new IllegalStateException("Migration didn't properly handle plugin(com.flybits.context.models.internal.Plugin).\n Expected:\n" + _infoPlugin + "\n Found:\n" + _existingPlugin);
                }
                HashMap<String, TableInfo.Column> _columnsRuleEvaluations = new HashMap<String, TableInfo.Column>(3);
                _columnsRuleEvaluations.put("ruleEvaluationID", new TableInfo.Column("ruleEvaluationID", "TEXT", true, 1));
                _columnsRuleEvaluations.put("name", new TableInfo.Column("name", "TEXT", false, 0));
                _columnsRuleEvaluations.put("isLastResult", new TableInfo.Column("isLastResult", "INTEGER", true, 0));
                HashSet _foreignKeysRuleEvaluations = new HashSet(0);
                HashSet _indicesRuleEvaluations = new HashSet(0);
                TableInfo _infoRuleEvaluations = new TableInfo("ruleEvaluations", _columnsRuleEvaluations, _foreignKeysRuleEvaluations, _indicesRuleEvaluations);
                TableInfo _existingRuleEvaluations = TableInfo.read((SupportSQLiteDatabase)_db, (String)"ruleEvaluations");
                if (!_infoRuleEvaluations.equals((Object)_existingRuleEvaluations)) {
                    throw new IllegalStateException("Migration didn't properly handle ruleEvaluations(com.flybits.context.models.RuleEvalutated).\n Expected:\n" + _infoRuleEvaluations + "\n Found:\n" + _existingRuleEvaluations);
                }
                HashMap<String, TableInfo.Column> _columnsContextData = new HashMap<String, TableInfo.Column>(4);
                _columnsContextData.put("contextID", new TableInfo.Column("contextID", "TEXT", true, 1));
                _columnsContextData.put("isSent", new TableInfo.Column("isSent", "INTEGER", true, 0));
                _columnsContextData.put("lastUpdated", new TableInfo.Column("lastUpdated", "INTEGER", true, 0));
                _columnsContextData.put("data", new TableInfo.Column("data", "TEXT", false, 0));
                HashSet _foreignKeysContextData = new HashSet(0);
                HashSet _indicesContextData = new HashSet(0);
                TableInfo _infoContextData = new TableInfo("contextData", _columnsContextData, _foreignKeysContextData, _indicesContextData);
                TableInfo _existingContextData = TableInfo.read((SupportSQLiteDatabase)_db, (String)"contextData");
                if (!_infoContextData.equals((Object)_existingContextData)) {
                    throw new IllegalStateException("Migration didn't properly handle contextData(com.flybits.context.models.BasicData).\n Expected:\n" + _infoContextData + "\n Found:\n" + _existingContextData);
                }
                HashMap<String, TableInfo.Column> _columnsBeaconsActive = new HashMap<String, TableInfo.Column>(8);
                _columnsBeaconsActive.put("id1", new TableInfo.Column("id1", "TEXT", false, 0));
                _columnsBeaconsActive.put("id2", new TableInfo.Column("id2", "TEXT", false, 0));
                _columnsBeaconsActive.put("id3", new TableInfo.Column("id3", "TEXT", false, 0));
                _columnsBeaconsActive.put("type", new TableInfo.Column("type", "TEXT", false, 0));
                _columnsBeaconsActive.put("lastSeen", new TableInfo.Column("lastSeen", "INTEGER", true, 0));
                _columnsBeaconsActive.put("isSent", new TableInfo.Column("isSent", "INTEGER", true, 0));
                _columnsBeaconsActive.put("isInRange", new TableInfo.Column("isInRange", "INTEGER", true, 0));
                _columnsBeaconsActive.put("id", new TableInfo.Column("id", "TEXT", true, 1));
                HashSet _foreignKeysBeaconsActive = new HashSet(0);
                HashSet _indicesBeaconsActive = new HashSet(0);
                TableInfo _infoBeaconsActive = new TableInfo("beaconsActive", _columnsBeaconsActive, _foreignKeysBeaconsActive, _indicesBeaconsActive);
                TableInfo _existingBeaconsActive = TableInfo.read((SupportSQLiteDatabase)_db, (String)"beaconsActive");
                if (!_infoBeaconsActive.equals((Object)_existingBeaconsActive)) {
                    throw new IllegalStateException("Migration didn't properly handle beaconsActive(com.flybits.context.plugins.beacon.BeaconActive).\n Expected:\n" + _infoBeaconsActive + "\n Found:\n" + _existingBeaconsActive);
                }
                HashMap<String, TableInfo.Column> _columnsBeaconsMonitored = new HashMap<String, TableInfo.Column>(2);
                _columnsBeaconsMonitored.put("type", new TableInfo.Column("type", "TEXT", false, 0));
                _columnsBeaconsMonitored.put("uuid", new TableInfo.Column("uuid", "TEXT", true, 1));
                HashSet _foreignKeysBeaconsMonitored = new HashSet(0);
                HashSet _indicesBeaconsMonitored = new HashSet(0);
                TableInfo _infoBeaconsMonitored = new TableInfo("beaconsMonitored", _columnsBeaconsMonitored, _foreignKeysBeaconsMonitored, _indicesBeaconsMonitored);
                TableInfo _existingBeaconsMonitored = TableInfo.read((SupportSQLiteDatabase)_db, (String)"beaconsMonitored");
                if (!_infoBeaconsMonitored.equals((Object)_existingBeaconsMonitored)) {
                    throw new IllegalStateException("Migration didn't properly handle beaconsMonitored(com.flybits.context.plugins.beacon.BeaconMonitored).\n Expected:\n" + _infoBeaconsMonitored + "\n Found:\n" + _existingBeaconsMonitored);
                }
            }
        }, "bd8edc5b9768651eb1d6283992b9e605", "83092c8ea2a7bdda125f8fc119da53ea");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        return new InvalidationTracker((RoomDatabase)this, new String[]{"plugin", "ruleEvaluations", "contextData", "beaconsActive", "beaconsMonitored"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `plugin`");
            _db.execSQL("DELETE FROM `ruleEvaluations`");
            _db.execSQL("DELETE FROM `contextData`");
            _db.execSQL("DELETE FROM `beaconsActive`");
            _db.execSQL("DELETE FROM `beaconsMonitored`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBPluginDAO pluginDao() {
        if (this._dBPluginDAO != null) {
            return this._dBPluginDAO;
        }
        ContextDatabase_Impl contextDatabase_Impl = this;
        synchronized (contextDatabase_Impl) {
            if (this._dBPluginDAO == null) {
                this._dBPluginDAO = new DBPluginDAO_Impl(this);
            }
            return this._dBPluginDAO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleEvaluationDAO ruleDao() {
        if (this._ruleEvaluationDAO != null) {
            return this._ruleEvaluationDAO;
        }
        ContextDatabase_Impl contextDatabase_Impl = this;
        synchronized (contextDatabase_Impl) {
            if (this._ruleEvaluationDAO == null) {
                this._ruleEvaluationDAO = new RuleEvaluationDAO_Impl(this);
            }
            return this._ruleEvaluationDAO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BasicDataDAO basicDataDao() {
        if (this._basicDataDAO != null) {
            return this._basicDataDAO;
        }
        ContextDatabase_Impl contextDatabase_Impl = this;
        synchronized (contextDatabase_Impl) {
            if (this._basicDataDAO == null) {
                this._basicDataDAO = new BasicDataDAO_Impl(this);
            }
            return this._basicDataDAO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeaconActiveDAO beaconActiveDao() {
        if (this._beaconActiveDAO != null) {
            return this._beaconActiveDAO;
        }
        ContextDatabase_Impl contextDatabase_Impl = this;
        synchronized (contextDatabase_Impl) {
            if (this._beaconActiveDAO == null) {
                this._beaconActiveDAO = new BeaconActiveDAO_Impl(this);
            }
            return this._beaconActiveDAO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeaconMonitoredDAO beaconMonitoredDao() {
        if (this._beaconMonitoredDAO != null) {
            return this._beaconMonitoredDAO;
        }
        ContextDatabase_Impl contextDatabase_Impl = this;
        synchronized (contextDatabase_Impl) {
            if (this._beaconMonitoredDAO == null) {
                this._beaconMonitoredDAO = new BeaconMonitoredDAO_Impl(this);
            }
            return this._beaconMonitoredDAO;
        }
    }
}

