/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge;

import android.content.Context;
import android.content.SharedPreferences;

public class InternalPreferences {
    private static final String PREFS_NAME = "ConciergePrefs";
    private static final String TNC_ACCEPTED = "tnc_accepted";
    private static final String FB_PUSH_TOKEN = "fire_base_push_token";
    private static final String ONBOARDING_DONE = "onboarded";
    private static final String SURVEY_DONE = "survey_done";
    private static final String AUTO_AUTH_ON_CONNECT = "auto_authenticate";
    private static final String SELF_USER_OPTED_OUT = "self_optOut";
    protected static final String IS_2PHASE_OPTED_IN = "ctn_flybits_2_phase_opted_in";
    private static final String IS_OPTOUT_CONFIRMATION = "opt_out_confirmation";
    private static final String IS_OPTOUTCONFIRMATION_ADDED = "optOutConfirmation_added";

    private static SharedPreferences getInstance(Context context) {
        return context.getSharedPreferences(PREFS_NAME, 0);
    }

    public static void saveTNCAccepted(Context currentContext, boolean value) {
        currentContext.getSharedPreferences(PREFS_NAME, 0).edit().putBoolean(TNC_ACCEPTED, value).apply();
    }

    private static SharedPreferences.Editor getSaveInstance(Context context) {
        return InternalPreferences.getInstance(context).edit();
    }

    public static boolean isTNCAccepted(Context context) {
        return InternalPreferences.getInstance(context).getBoolean(TNC_ACCEPTED, false);
    }

    public static void setAutoRetryAuthOnConnected(Context currentContext, boolean value) {
        InternalPreferences.getSaveInstance(currentContext).putBoolean(AUTO_AUTH_ON_CONNECT, value).apply();
    }

    public static boolean isAutoRetryAuthOnConnectedEnabled(Context currentContext) {
        return InternalPreferences.getInstance(currentContext).getBoolean(AUTO_AUTH_ON_CONNECT, true);
    }

    public static boolean isOnBoardingDone(Context context) {
        return InternalPreferences.getInstance(context).getBoolean(ONBOARDING_DONE, false);
    }

    public static void saveOnBoardingDone(Context currentContext, boolean value) {
        InternalPreferences.getSaveInstance(currentContext).putBoolean(ONBOARDING_DONE, value).apply();
    }

    public static void savePushToken(Context currentContext, String value) {
        InternalPreferences.getSaveInstance(currentContext).putString(FB_PUSH_TOKEN, value).apply();
    }

    public static String pushToken(Context currentContext) {
        return InternalPreferences.getInstance(currentContext).getString(FB_PUSH_TOKEN, null);
    }

    static boolean isSurveyDone(Context currentContext) {
        return InternalPreferences.getInstance(currentContext).getBoolean(SURVEY_DONE, false);
    }

    public static void saveSurveyDone(Context currentContext, boolean value) {
        InternalPreferences.getSaveInstance(currentContext).putBoolean(SURVEY_DONE, value).apply();
    }

    public static boolean is2PhaseOptIn(Context currentContext) {
        return InternalPreferences.getInstance(currentContext).getBoolean(IS_2PHASE_OPTED_IN, false);
    }

    public static void setIs2phaseOptedIn(Context currentContext, boolean value) {
        InternalPreferences.getSaveInstance(currentContext).putBoolean(IS_2PHASE_OPTED_IN, value).apply();
    }

    public static void setSelfUserOptedOut(Context currentContext, boolean value) {
        InternalPreferences.getSaveInstance(currentContext).putBoolean(SELF_USER_OPTED_OUT, value).apply();
    }

    static boolean isSelfOptedOut(Context currentContext) {
        return InternalPreferences.getInstance(currentContext).getBoolean(SELF_USER_OPTED_OUT, false);
    }

    public static boolean isOptOutConfirmation(Context currentContext) {
        return InternalPreferences.getInstance(currentContext).getBoolean(IS_OPTOUT_CONFIRMATION, false);
    }

    public static void setOptOutConfirmation(Context currentContext, boolean value) {
        InternalPreferences.getSaveInstance(currentContext).putBoolean(IS_OPTOUT_CONFIRMATION, value).apply();
    }

    public static boolean isOptOutConfirmationAdded(Context currentContext) {
        return InternalPreferences.getInstance(currentContext).getBoolean(IS_OPTOUTCONFIRMATION_ADDED, false);
    }

    public static void setOptOutConfirmationAdded(Context currentContext, boolean value) {
        InternalPreferences.getSaveInstance(currentContext).putBoolean(IS_OPTOUTCONFIRMATION_ADDED, value).apply();
    }
}

