package com.flybits.concierge.fragments

import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.bumptech.glide.request.RequestOptions
import com.flybits.android.kernel.ContentAnalytics
import com.flybits.concierge.R
import com.flybits.concierge.UserActionHandler
import com.flybits.concierge.models.ActionCard


class ActionCardDetailFragment : Fragment() {


    private var actionCard: ActionCard? = null
    private var contentAnalytics: ContentAnalytics? = null
    private var userActionHandler: UserActionHandler<ActionCard>? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            actionCard = it.getParcelable(ARG_ACTIONCARD)
            userActionHandler = it.getParcelable(ARG_USER_ACTION_HANDLER)
        }
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.flybits_streamline_detail, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        val bannerView: ImageView =
            view.findViewById(R.id.flybits_streamline_detail_imageHeader)
        val headerView: TextView =
            view.findViewById(R.id.flybits_streamline_detail_header)
        val titleView: TextView =
            view.findViewById(R.id.flybits_streamline_detail_title)
        val bodyView: TextView =
            view.findViewById(R.id.flybits_streamline_detail_body)
        val descriptionView: TextView =
            view.findViewById(R.id.flybits_streamline_detail_description)

        actionCard?.image?.value.let {
            if (it.isNullOrEmpty()) {
                bannerView.visibility = View.GONE
            } else {
                Glide.with(bannerView.context).load(it)
                    .apply(RequestOptions().centerCrop()).into(bannerView)
            }
        }

        actionCard?.header?.value.let {
            if (it.isNullOrEmpty()) {
                headerView.visibility = View.GONE
            } else {
                headerView.text = it
            }
        }

        titleView.text = actionCard?.title?.value

        actionCard?.description?.value.let {
            if (it.isNullOrEmpty()) {
                descriptionView.visibility = View.GONE
            } else {
                descriptionView.text = it
            }
        }

        actionCard?.details?.body?.value.let {
            if (it.isNullOrEmpty()) {
                bodyView.visibility = View.GONE
            } else {
                bodyView.text = it
            }
        }

    }


    companion object {
        private const val ARG_ACTIONCARD = "arg_actioncard"
        private const val ARG_USER_ACTION_HANDLER = "arg_user_action_handler"

        @JvmStatic
        fun newInstance(
            actionCard: ActionCard,
            userActionHandler: UserActionHandler<ActionCard>
        ) =
            ActionCardDetailFragment().apply {
                arguments = Bundle().apply {
                    putParcelable(ARG_ACTIONCARD, actionCard)
                    putParcelable(ARG_USER_ACTION_HANDLER, userActionHandler)
                }
            }
    }
}
