/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.services;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import com.flybits.android.push.models.newPush.ContentPush;
import com.flybits.android.push.models.newPush.DisplayablePush;
import com.flybits.android.push.models.newPush.EventPush;
import com.flybits.android.push.services.PushService;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.FlybitsConcierge;
import com.flybits.concierge.InternalPreferences;
import com.flybits.concierge.Utils;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/flybits/concierge/services/ConciergeMessagingService;", "Lcom/flybits/android/push/services/PushService;", "autoUpdate", "", "(Z)V", "onDisplayableFlybitsPushReceived", "", "push", "Lcom/flybits/android/push/models/newPush/DisplayablePush;", "onEntityFlybitsPushReceived", "Lcom/flybits/android/push/models/newPush/EventPush;", "onNewToken", "recentToken", "", "Companion", "concierge_release"})
public abstract class ConciergeMessagingService
extends PushService {
    private final boolean autoUpdate;
    public static final Companion Companion = new Companion(null);

    public void onDisplayableFlybitsPushReceived(@NotNull DisplayablePush push) {
        Intrinsics.checkParameterIsNotNull((Object)push, (String)"push");
        super.onDisplayableFlybitsPushReceived(push);
        if (push instanceof ContentPush) {
            Logger.i((String)("ContentPush received " + push));
            Companion.broadcastIntent((Context)this, "flybits_con_broadcast_content_push_received");
        }
    }

    public void onEntityFlybitsPushReceived(@NotNull EventPush push) {
        Intrinsics.checkParameterIsNotNull((Object)push, (String)"push");
        super.onEntityFlybitsPushReceived(push);
        Logger.i((String)("RelevantContentPush received " + push));
        if (this.autoUpdate) {
            Companion.broadcastIntent((Context)this, "flybits_con_broadcast_entity_push_received");
        }
    }

    public void onNewToken(@Nullable String recentToken) {
        super.onNewToken(recentToken);
        Logger.appendTag((String)"ConciergeMessagingService").d("onNewToken() token: " + recentToken);
        if (recentToken != null) {
            FlybitsConcierge.with(this.getApplicationContext()).enablePushMessaging(recentToken);
        }
    }

    public ConciergeMessagingService(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public /* synthetic */ ConciergeMessagingService(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public ConciergeMessagingService() {
        this(false, 1, null);
    }

    @JvmStatic
    public static final void savePushToken(@NotNull String recentToken, @NotNull Context context) {
        Companion.savePushToken(recentToken, context);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nJ\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0012"}, d2={"Lcom/flybits/concierge/services/ConciergeMessagingService$Companion;", "", "()V", "broadcastIntent", "", "context", "Landroid/content/Context;", "action", "", "createIntent", "Landroid/content/Intent;", "push", "Lcom/flybits/android/push/models/newPush/DisplayablePush;", "createPendingIntent", "Landroid/app/PendingIntent;", "intent", "savePushToken", "recentToken", "concierge_release"})
    public static final class Companion {
        @NotNull
        public final PendingIntent createPendingIntent(@NotNull Context context, @NotNull DisplayablePush push, @NotNull Intent intent) throws FlybitsException {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)push, (String)"push");
            Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)push.getId().hashCode(), (Intent)intent, (int)0x8000000);
            Intrinsics.checkExpressionValueIsNotNull((Object)pendingIntent, (String)"PendingIntent.getActivit\u2026ATE_CURRENT\n            )");
            return pendingIntent;
        }

        @NotNull
        public final Intent createIntent(@NotNull Context context, @NotNull DisplayablePush push) throws FlybitsException {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)push, (String)"push");
            Class<Activity> clazz = Utils.launcherActivity(context);
            if (clazz == null) {
                throw (Throwable)new FlybitsException("No launcher activity found!");
            }
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Utils.launcherActivity(c\u2026auncher activity found!\")");
            Class<Activity> activityClass = clazz;
            Intent intent = new Intent(context, activityClass);
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$apply = intent;
            boolean bl3 = false;
            $this$apply.setFlags(0x34000000);
            $this$apply.putExtra("flybits_con_push_extra", (Parcelable)push);
            return intent;
        }

        @JvmStatic
        public final void savePushToken(@NotNull String recentToken, @NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)recentToken, (String)"recentToken");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            InternalPreferences.savePushToken(context, recentToken);
        }

        public final void broadcastIntent(@NotNull Context context, @NotNull String action) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
            Intent intent = new Intent();
            boolean bl = false;
            boolean bl2 = false;
            Intent intent2 = intent;
            boolean bl3 = false;
            intent2.setAction(action);
            context.sendBroadcast(intent2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

