package com.flybits.concierge.fragments

import android.content.pm.ActivityInfo
import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.*
import com.flybits.concierge.InternalPreferences
import com.flybits.concierge.R
import kotlinx.android.synthetic.main.flybits_con_fragment_opt_out_confirmation.*

class OptOutConfirmationFragment : Fragment() {
    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.flybits_con_fragment_opt_out_confirmation, container, false)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        opt_out_confirmation_btn.setOnClickListener {
            // on click OPT IN, we setOptOutConfirmationAdded(true)
            InternalPreferences.setOptOutConfirmationAdded(context, true)
            val frag = OptInFragment.newInstance()
            InternalPreferences.setOptOutConfirmation(context, false)
            val fragmentManager = activity?.supportFragmentManager
            fragmentManager?.beginTransaction()
                ?.remove(this)
                ?.add(R.id.concierge_fragment_lytContent, frag)
                ?.addToBackStack(OPTOUT_CONF_FRAG_STACK_TAG)
                ?.commit()
        }
    }

    companion object {
        const val OPTOUT_CONF_FRAG_STACK_TAG = "BACK_STACK_TAG"
        @JvmStatic
        fun newInstance(): OptOutConfirmationFragment {
            val fragment = OptOutConfirmationFragment()
            val args = Bundle()
            fragment.arguments = args
            return fragment
        }
    }
}