/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.adapters;

import android.content.Context;
import android.text.style.CharacterStyle;
import android.text.style.StyleSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.TextView;
import com.flybits.commons.library.logging.Logger;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.data.DataBufferUtils;
import com.google.android.gms.location.places.AutocompleteFilter;
import com.google.android.gms.location.places.AutocompletePrediction;
import com.google.android.gms.location.places.AutocompletePredictionBufferResponse;
import com.google.android.gms.location.places.GeoDataClient;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class PlaceAutocompleteAdapter
extends ArrayAdapter<AutocompletePrediction>
implements Filterable {
    private static final String TAG = PlaceAutocompleteAdapter.class.getSimpleName();
    private static final CharacterStyle STYLE_BOLD = new StyleSpan(1);
    private ArrayList<AutocompletePrediction> resultList;
    private GeoDataClient geoDataClient;
    private LatLngBounds bounds;
    private AutocompleteFilter placeFilter;

    public PlaceAutocompleteAdapter(Context context, GeoDataClient geoDataClient, LatLngBounds bounds, AutocompleteFilter filter) {
        super(context, 17367047, 16908308);
        this.geoDataClient = geoDataClient;
        this.bounds = bounds;
        this.placeFilter = filter;
    }

    public void setBounds(LatLngBounds bounds) {
        this.bounds = bounds;
    }

    public int getCount() {
        return this.resultList.size();
    }

    public AutocompletePrediction getItem(int position) {
        return this.resultList.get(position);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View row = super.getView(position, convertView, parent);
        AutocompletePrediction item = this.getItem(position);
        TextView textView1 = (TextView)row.findViewById(16908308);
        TextView textView2 = (TextView)row.findViewById(16908309);
        textView1.setText(item.getPrimaryText(STYLE_BOLD));
        textView2.setText(item.getSecondaryText(STYLE_BOLD));
        return row;
    }

    public Filter getFilter() {
        return new Filter(){

            protected Filter.FilterResults performFiltering(CharSequence constraint) {
                Filter.FilterResults results = new Filter.FilterResults();
                ArrayList filterData = new ArrayList();
                if (constraint != null) {
                    filterData = PlaceAutocompleteAdapter.this.getAutocomplete(constraint);
                }
                results.values = filterData;
                results.count = filterData != null ? filterData.size() : 0;
                return results;
            }

            protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
                if (results != null && results.count > 0) {
                    PlaceAutocompleteAdapter.this.resultList = (ArrayList)results.values;
                    PlaceAutocompleteAdapter.this.notifyDataSetChanged();
                } else {
                    PlaceAutocompleteAdapter.this.notifyDataSetInvalidated();
                }
            }

            public CharSequence convertResultToString(Object resultValue) {
                if (resultValue instanceof AutocompletePrediction) {
                    return ((AutocompletePrediction)resultValue).getFullText(null);
                }
                return super.convertResultToString(resultValue);
            }
        };
    }

    private ArrayList<AutocompletePrediction> getAutocomplete(CharSequence constraint) {
        Logger.i((String)("Starting autocomplete query for: " + constraint));
        Task results = this.geoDataClient.getAutocompletePredictions(constraint.toString(), this.bounds, this.placeFilter);
        try {
            Tasks.await((Task)results, (long)60L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Logger.exception((String)PlaceAutocompleteAdapter.class.getSimpleName(), (Exception)e);
        }
        try {
            AutocompletePredictionBufferResponse autocompletePredictions = (AutocompletePredictionBufferResponse)results.getResult();
            Logger.i((String)("Query completed. Received " + autocompletePredictions.getCount() + " predictions."));
            return DataBufferUtils.freezeAndClose((DataBuffer)autocompletePredictions);
        }
        catch (RuntimeExecutionException e) {
            Logger.exception((String)PlaceAutocompleteAdapter.class.getSimpleName(), (Exception)((Object)e));
            return null;
        }
    }
}

