package com.flybits.concierge.repository

import android.content.Context
import android.os.Handler
import com.flybits.commons.library.api.results.ObjectResult
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback
import com.flybits.commons.library.models.JsonParser
import com.flybits.commons.library.models.Project

class ProjectSettingsGetter(private val context: Context){
    fun <T: JsonParser>getProjectSettings(type: String, classType: Class<T>, callback: ObjectResultCallback<T>, handler: Handler): ObjectResult<T> {
        return Project.getSettings(type, context.applicationContext, classType, callback, handler)
    }
}