package com.flybits.concierge.activities

import android.os.Bundle
import android.view.MenuItem
import com.flybits.concierge.ConciergeFragment
import com.flybits.concierge.DisplayConfiguration
import com.flybits.concierge.R
import com.flybits.concierge.enums.ShowMode

/**
 * Wrapper activity to hold the ConciergeFragment if the developer does not want to embed
 * the fragment in their views.
 */

class ConciergeActivity : ConciergeAbstractActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.flybits_con_activity_concierge)
        setTitle(R.string.flybits_con_concierge)

        val actionBar = supportActionBar
        if (actionBar != null) {
            actionBar.setHomeButtonEnabled(true)
            actionBar.setDisplayHomeAsUpEnabled(true)
        }

        val menuType = if (supportActionBar != null) {
            ConciergeFragment.MenuType.MENU_TYPE_APP_BAR
        } else {
            ConciergeFragment.MenuType.MENU_TYPE_TAB
        }
        val fragment = ConciergeFragment.newInstance(
            intent.getParcelableExtra<DisplayConfiguration>(ARG_DISPLAY_CONFIGURATION)
        )
        fragment.setCallback { finish() }
        openFragment(fragment)
    }

    override fun onOptionsItemSelected(item: MenuItem?): Boolean {
        return if (item?.itemId == android.R.id.home) {
            onBackPressed()
            true
        }
        else {
            super.onOptionsItemSelected(item)
        }
    }

    companion object {
        const val ARG_DISPLAY_CONFIGURATION = "flybits_con_display_configuration"
    }
}
