/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.viewmodels;

import android.app.Application;
import android.arch.lifecycle.AndroidViewModel;
import android.support.annotation.NonNull;
import android.util.LongSparseArray;
import com.flybits.android.kernel.models.Content;
import com.flybits.android.kernel.reservedtemplates.survey.models.SurveyAnswer;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;

public class SurveyViewModel
extends AndroidViewModel {
    private LongSparseArray<Object> answers = new LongSparseArray();
    private BasicResultCallback basicResultCallback;
    private boolean isSubmitting;

    public SurveyViewModel(@NonNull Application application) {
        super(application);
    }

    public LongSparseArray<Object> getAnswers() {
        return this.answers;
    }

    public void setBasicResultCallback(BasicResultCallback callback) {
        this.basicResultCallback = callback;
    }

    public boolean isSubmitting() {
        return this.isSubmitting;
    }

    public void submitSurveyAnswers(SurveyAnswer surveyAnswer, Content content) {
        this.isSubmitting = true;
        surveyAnswer.saveSurveyAnswers(this.getApplication().getApplicationContext(), content, new BasicResultCallback(){

            public void onSuccess() {
                SurveyViewModel.this.isSubmitting = false;
                if (SurveyViewModel.this.basicResultCallback != null) {
                    SurveyViewModel.this.basicResultCallback.onSuccess();
                }
            }

            public void onException(FlybitsException exception) {
                SurveyViewModel.this.isSubmitting = false;
                if (SurveyViewModel.this.basicResultCallback != null) {
                    SurveyViewModel.this.basicResultCallback.onException(exception);
                }
            }
        });
    }
}

