/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.viewholders;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Link;
import com.flybits.concierge.models.Links;
import com.flybits.concierge.viewholders.FlybitsViewHolder;
import com.flybits.concierge.viewpopulators.LinksViewPopulator;

public class LinksViewHolder
extends FlybitsViewHolder<Links> {
    private LinearLayout thisView;
    private LinksViewPopulator linksViewPopulator;
    private View linkView;
    private TextView linkHeading;
    private TextView linkBody;
    private View linkViewRule;

    public LinksViewHolder(View view, LinksViewPopulator linksViewPopulator) {
        super(view);
        this.thisView = (LinearLayout)view;
        this.linksViewPopulator = linksViewPopulator;
    }

    @Override
    public void bindData(Links data, FlybitsNavigator flybitsNavigator) {
        this.thisView.removeAllViews();
        boolean isLinkAdded = false;
        for (Link link : data.links.getList()) {
            this.linkView = LayoutInflater.from((Context)this.thisView.getContext()).inflate(R.layout.flybits_con_item_template_link, (ViewGroup)this.thisView, false);
            this.linkHeading = (TextView)this.linkView.findViewById(R.id.flybits_con_item_template_link_txtTitle);
            this.linkBody = (TextView)this.linkView.findViewById(R.id.flybits_con_item_template_link_txtBody);
            this.linkViewRule = this.linkView.findViewById(R.id.flybits_con_item_template_link_viewRule);
            if (!isLinkAdded) {
                this.linkViewRule.setVisibility(0);
                isLinkAdded = true;
            } else {
                this.linkViewRule.setVisibility(8);
            }
            this.linksViewPopulator.populate(link, data.getContent().getId(), this.linkHeading, this.linkBody, this.linkView);
            this.thisView.addView(this.linkView);
        }
    }
}

