/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.repository;

import com.flybits.android.kernel.models.Content;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.FlybitsViewProvider;
import com.flybits.concierge.FlybitsViewProviderGetter;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.repository.content.ContentGetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\t\u001a\u00020\nJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/flybits/concierge/repository/ModelConverter;", "", "contentGetter", "Lcom/flybits/concierge/repository/content/ContentGetter;", "flybitsViewProviderGetter", "Lcom/flybits/concierge/FlybitsViewProviderGetter;", "(Lcom/flybits/concierge/repository/content/ContentGetter;Lcom/flybits/concierge/FlybitsViewProviderGetter;)V", "contentToBaseTemplate", "Lcom/flybits/concierge/models/BaseTemplate;", "content", "Lcom/flybits/android/kernel/models/Content;", "typeClass", "Ljava/lang/Class;", "getSupportedTypes", "", "", "concierge_release"})
public final class ModelConverter {
    private final ContentGetter contentGetter;
    private final FlybitsViewProviderGetter flybitsViewProviderGetter;

    @Nullable
    public final BaseTemplate contentToBaseTemplate(@NotNull Content content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        FlybitsViewProvider flybitsViewProvider = this.flybitsViewProviderGetter.getFlybitsViewProvider(content.getType());
        if (flybitsViewProvider == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)flybitsViewProvider, (String)"flybitsViewProviderGette\u2026tent.type) ?: return null");
        FlybitsViewProvider flybitsViewProvider2 = flybitsViewProvider;
        Class<BaseTemplate> typeClass = flybitsViewProvider2.getClassType();
        return this.contentToBaseTemplate(typeClass, content);
    }

    @Nullable
    public final BaseTemplate contentToBaseTemplate(@NotNull Class<BaseTemplate> typeClass, @NotNull Content content) {
        BaseTemplate baseTemplate;
        Intrinsics.checkParameterIsNotNull(typeClass, (String)"typeClass");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        try {
            baseTemplate = this.contentGetter.getData(content, typeClass);
        }
        catch (FlybitsException e) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.getDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
            Locale locale2 = locale;
            String string2 = "Developer: Invalid Template Found: %s";
            Object[] objectArray = new Object[]{content.getType()};
            boolean bl = false;
            String string3 = String.format(locale2, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
            Logger.d((String)string3);
            String string4 = BaseTemplate.class.getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"BaseTemplate::class.java.simpleName");
            Logger.exception((String)string4, (Exception)((Exception)((Object)e)));
            baseTemplate = null;
        }
        return baseTemplate;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getSupportedTypes() {
        List list;
        Collection<FlybitsViewProvider> collection = this.flybitsViewProviderGetter.getFlybitsViewProviders();
        if (collection != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FlybitsViewProvider flybitsViewProvider = (FlybitsViewProvider)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                String string2 = it.getContentType();
                collection2.add(string2);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public ModelConverter(@NotNull ContentGetter contentGetter, @NotNull FlybitsViewProviderGetter flybitsViewProviderGetter) {
        Intrinsics.checkParameterIsNotNull((Object)contentGetter, (String)"contentGetter");
        Intrinsics.checkParameterIsNotNull((Object)flybitsViewProviderGetter, (String)"flybitsViewProviderGetter");
        this.contentGetter = contentGetter;
        this.flybitsViewProviderGetter = flybitsViewProviderGetter;
    }
}

