package com.flybits.concierge.viewproviders

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import com.flybits.android.kernel.ContentAnalytics
import com.flybits.concierge.*
import com.flybits.concierge.fragments.VideoPlaylistFragment
import com.flybits.concierge.models.Videos
import com.flybits.concierge.viewholders.VideosViewHolder
import com.flybits.concierge.viewpopulators.VideoViewPopulator

class VideosViewProvider internal constructor(private val videoViewPopulator: VideoViewPopulator): FlybitsViewProvider<Videos> {

    constructor(context : Context) : this(VideoViewPopulator(ContentAnalytics(context)))

    override fun getClassType() = Videos::class.java

    override fun getContentType() = ConciergeConstants.VIDEO_CONTENT_TYPE

    override fun onCreateViewHolder(parent: ViewGroup): VideosViewHolder {
        return VideosViewHolder(LayoutInflater.from(parent.context)
                .inflate(R.layout.flybits_con_item_template_videos, parent, false), videoViewPopulator)
    }

    override fun onPushOpened(model: Videos, flybitsNavigator: FlybitsNavigator) {
        model.videos.list.forEach { it.content = model.content } //needed for analytics this is a hack
        flybitsNavigator.openFragment(VideoPlaylistFragment.newInstance(model.videos.list))
    }
}