package com.flybits.concierge.viewholders;

import android.view.View;
import android.widget.ImageView;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Videos;
import com.flybits.concierge.viewpopulators.VideoViewPopulator;

public class VideosViewHolder extends FlybitsViewHolder<Videos>
{
    private View thisView;
    private ImageView[] singlePlaceHolderViews;
    private ImageView[] doublePlaceHolderViews;
    private ImageView[] triplePlaceHolderViews;
    private View tripleContainer;
    private View doubleContainer;
    private View singleContainer;
    private View callToActionView;
    private VideoViewPopulator videoViewPopulator;

    public VideosViewHolder(View view, VideoViewPopulator videoViewPopulator)
    {
        super(view);
        this.thisView = view;
        this.videoViewPopulator = videoViewPopulator;

        triplePlaceHolderViews = new ImageView[] {
                view.findViewById(R.id.flybits_con_item_template_videos_imgBig),
                view.findViewById(R.id.flybits_con_item_template_videos_imgTR),
                view.findViewById(R.id.flybits_con_item_template_videos_imgBR)
        };

        doublePlaceHolderViews = new ImageView[] {
                view.findViewById(R.id.flybits_con_item_template_videos_imgLeft),
                view.findViewById(R.id.flybits_con_item_template_videos_imgRight)
        };

        singlePlaceHolderViews = new ImageView[] {
                view.findViewById(R.id.flybits_con_item_template_videos_single),
        };

        tripleContainer = view.findViewById(R.id.flybits_con_item_template_videos_triple);
        doubleContainer = view.findViewById(R.id.flybits_con_item_template_videos_double);
        singleContainer = view.findViewById(R.id.flybits_con_item_template_videos_single_container);
        callToActionView = view.findViewById(R.id.flybits_con_item_template_videos_callToAction);
    }

    @Override
    public void bindData(final Videos data, final FlybitsNavigator flybitsNavigator)
    {
        videoViewPopulator.populate(data, flybitsNavigator, thisView, singleContainer
                , doubleContainer, tripleContainer, singlePlaceHolderViews, doublePlaceHolderViews
                , triplePlaceHolderViews, callToActionView);
    }
}
