package com.flybits.concierge;

/**
 * Set in the {@code FlybitsConcierge} and is notified about when the user opts out or in if set.
 */
public interface OptedStateChangeListener
{
    /**
     * This method should include logic for not allowing the {@code FlybitsConcierge} show method to be invoked.
     *
     * @param optedIn Whether the user is opted in or out.
     */
    void onOptedStateChange(boolean optedIn);
}
