package com.flybits.concierge.activities

import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.support.design.widget.Snackbar
import android.support.v4.app.Fragment
import android.support.v7.app.AppCompatActivity
import android.view.MenuItem
import com.afollestad.materialdialogs.MaterialDialog
import com.flybits.commons.library.logging.Logger
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.R

/**
 * This activity is responsible for displaying a single fragment, a back button in the menu,
 * and implementing the [FlybitsNavigator] functionality.
 *
 * @param title Title to be displayed in the app bar. Null by default, will result in
 * value defined in manifest.
 */
abstract class SingleFragmentActivity: AppCompatActivity(), FlybitsNavigator {

    /**
     * Returns the [Fragment] to be displayed when the activity is first created.
     *
     * @param intent [Intent] which contains all the extras used in creating this activity.
     */
    abstract fun onCreateSingleContentActivity(intent: Intent): Fragment

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.flybits_con_activity_single_content_holder)
        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        openFragment(onCreateSingleContentActivity(intent), false)
    }

    override fun onOptionsItemSelected(item: MenuItem?): Boolean {
        return if (item?.itemId == android.R.id.home) {
            onBackPressed()
            true
        } else {
            super.onOptionsItemSelected(item)
        }
    }

    override fun openFragment(fragment: Fragment, addToBackStack: Boolean) {
        val transaction = supportFragmentManager.beginTransaction()
        if (addToBackStack) {
            transaction.addToBackStack(null)
        }
        transaction.replace(R.id.flybits_con_fragment_holder, fragment)
                .commit()
    }

    override fun openActivity(activity: Class<*>, extras: Bundle) {
        val intent = Intent(this, activity)
        intent.putExtras(extras)
        startActivity(intent)
    }

    override fun openUrl(url: String): Boolean {
        val intent = Intent(Intent.ACTION_VIEW, Uri.parse(url))
        //verify that you're able to open url, if URL is malformed then exception is thrown
        return if (intent.resolveActivity(packageManager) != null){
            startActivity(intent)
            true
        } else {
            Logger.e("NotificationsActivity: Unable to show url $url, make sure it has http:// prefixed.")
            false
        }
    }

    override fun openSnackbar(content: String, length: Int) {
        Snackbar.make(findViewById(android.R.id.content), content, Snackbar.LENGTH_SHORT).show()

    }

    override fun dismiss() {
        onBackPressed()
    }

    override fun openDialog(content: String, title: String) {
        MaterialDialog.Builder(this)
                .title(title)
                .content(content)
                .positiveText(android.R.string.ok)
                .show()
    }
}