/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge;

import android.content.res.XmlResourceParser;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.concierge.ConciergeConfiguration;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/flybits/concierge/ConciergeConfigurationXMLParser;", "", "()V", "GATEWAY_URL", "", "OPT_IN_TEXT", "PRIVACY_URL", "PROJECT_ID", "TNC_URL", "generateConfigurationFromXML", "Lcom/flybits/concierge/ConciergeConfiguration;", "xmlResourceParser", "Landroid/content/res/XmlResourceParser;", "concierge_release"})
public final class ConciergeConfigurationXMLParser {
    private static final String PROJECT_ID = "projectID";
    private static final String GATEWAY_URL = "gatewayUrl";
    private static final String PRIVACY_URL = "privacyPolicyUrl";
    private static final String TNC_URL = "tncUrl";
    private static final String OPT_IN_TEXT = "optInTermsOfService";
    public static final ConciergeConfigurationXMLParser INSTANCE;

    @NotNull
    public final ConciergeConfiguration generateConfigurationFromXML(@NotNull XmlResourceParser xmlResourceParser) {
        Intrinsics.checkParameterIsNotNull((Object)xmlResourceParser, (String)"xmlResourceParser");
        Ref.LongRef longRef = new Ref.LongRef();
        String conciergeTag = "concierge";
        ConciergeConfiguration conciergeConfiguration = null;
        try {
            int eventType = xmlResourceParser.getEventType();
            ConciergeConfiguration.Builder conciergeConfigurationBuilder = null;
            while (eventType != 1) {
                switch (eventType) {
                    case 2: {
                        String string2;
                        String string3 = xmlResourceParser.getName();
                        if (!Intrinsics.areEqual((Object)string3, (Object)conciergeTag)) break;
                        longRef.element = xmlResourceParser.getAttributeIntValue(null, "timeToUploadContext", 10);
                        if (xmlResourceParser.getAttributeValue(null, PROJECT_ID) == null) {
                            throw (Throwable)new FlybitsException("Project ID must be specified");
                        }
                        boolean bl = false;
                        boolean bl2 = false;
                        String projectID = string2;
                        boolean bl3 = false;
                        conciergeConfigurationBuilder = new ConciergeConfiguration.Builder(projectID).setTimeToUploadContext(longRef.element);
                        String string4 = xmlResourceParser.getAttributeValue(null, TNC_URL);
                        if (string4 != null) {
                            string2 = string4;
                            bl = false;
                            bl2 = false;
                            String tncUrl = string2;
                            boolean bl4 = false;
                            ConciergeConfiguration.Builder builder = conciergeConfigurationBuilder;
                            if (builder == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"conciergeConfigurationBuilder");
                            }
                            builder.setTermsAndServicesRequired(tncUrl);
                        }
                        String string5 = xmlResourceParser.getAttributeValue(null, PRIVACY_URL);
                        if (string5 != null) {
                            string2 = string5;
                            bl = false;
                            bl2 = false;
                            String privacyPolicyUrl = string2;
                            boolean bl5 = false;
                            ConciergeConfiguration.Builder builder = conciergeConfigurationBuilder;
                            if (builder == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"conciergeConfigurationBuilder");
                            }
                            builder.setPrivacyPolicyUrl(privacyPolicyUrl);
                        }
                        String string6 = xmlResourceParser.getAttributeValue(null, GATEWAY_URL);
                        if (string6 != null) {
                            string2 = string6;
                            bl = false;
                            bl2 = false;
                            String gatewayUrl = string2;
                            boolean bl6 = false;
                            ConciergeConfiguration.Builder builder = conciergeConfigurationBuilder;
                            if (builder == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"conciergeConfigurationBuilder");
                            }
                            builder.setGatewayUrl(gatewayUrl);
                        }
                        String string7 = xmlResourceParser.getAttributeValue(null, OPT_IN_TEXT);
                        if (string7 != null) {
                            string2 = string7;
                            bl = false;
                            bl2 = false;
                            String optInTermsOfService = string2;
                            boolean bl7 = false;
                            ConciergeConfiguration.Builder builder = conciergeConfigurationBuilder;
                            if (builder == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"conciergeConfigurationBuilder");
                            }
                            builder.setOptInTermsOfService(optInTermsOfService);
                        }
                        ConciergeConfiguration.Builder builder = conciergeConfigurationBuilder;
                        if (builder == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"conciergeConfigurationBuilder");
                        }
                        conciergeConfiguration = builder.build();
                        break;
                    }
                    case 3: {
                        String string3 = xmlResourceParser.getName();
                        if (!Intrinsics.areEqual((Object)string3, (Object)conciergeTag)) break;
                        ConciergeConfiguration conciergeConfiguration2 = conciergeConfiguration;
                        if (conciergeConfiguration2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"conciergeConfiguration");
                        }
                        return conciergeConfiguration2;
                    }
                }
                eventType = xmlResourceParser.next();
            }
            throw (Throwable)new FlybitsException("Incorrect Concierge Configuration XML Format : No Concierge tag found");
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw (Throwable)new IllegalStateException("Concierge: Cfg syntax error.");
        }
        catch (IOException ioException) {
            throw (Throwable)new IOException("Concierge: Error reading XML resource.");
        }
    }

    private ConciergeConfigurationXMLParser() {
    }

    static {
        ConciergeConfigurationXMLParser conciergeConfigurationXMLParser;
        INSTANCE = conciergeConfigurationXMLParser = new ConciergeConfigurationXMLParser();
    }
}

