package com.flybits.concierge.fragments

import android.arch.lifecycle.Observer
import android.arch.lifecycle.ViewModelProviders
import android.content.Intent
import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.RelativeLayout
import android.widget.Switch
import com.afollestad.materialdialogs.MaterialDialog
import com.flybits.concierge.R
import com.flybits.concierge.activities.DocumentActivity
import com.flybits.concierge.activities.NotificationsActivity
import com.flybits.concierge.activities.SettingsActivity
import com.flybits.concierge.viewmodels.SettingsViewModel
import com.flybits.concierge.viewmodels.SettingsViewModelFactory
import kotlinx.android.synthetic.main.flybits_con_fragment_settings.*

class SettingsFragment : Fragment() {

    private var optSwitch: Switch? = null
    private var optOutDialog: MaterialDialog? = null
    internal var viewModel: SettingsViewModel? = null

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.flybits_con_fragment_settings, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        viewModel = ViewModelProviders.of(this, SettingsViewModelFactory(context!!)).get(SettingsViewModel::class.java)

        optSwitch = view.findViewById(R.id.flybits_con_settings_opt_switch)

        val activity = activity

        if (activity != null && optOutDialog == null) {
            optOutDialog = MaterialDialog.Builder(activity)
                    .title(getString(R.string.flybits_con_opt_out_title))
                    .positiveText(R.string.flybits_con_confirm)
                    .negativeText(R.string.flybits_con_cancel)
                    .content(R.string.flybits_con_opt_out_warning)
                    .onPositive { _, _ ->
                        progress_bar.visibility = View.VISIBLE
                        viewModel?.optOut()?.observe(this, Observer<SettingsViewModel.OptOutResult> {
                            if (it?.success == true) {
                                val activityNow = getActivity()
                                //Close settings and ConciergeActivity, if were nested in client activity then nothing will happen
                                if (activityNow is SettingsActivity){
                                    activityNow.setResult(SettingsActivity.RESULT_OPT_OUT)
                                    activityNow.finish()
                                }
                            } else {
                                val hostActivity = getActivity()
                                //Make sure user didn't exit settings
                                if (hostActivity != null) {
                                    MaterialDialog.Builder(hostActivity)
                                            .title(R.string.flybits_con_error)
                                            .content(R.string.flybits_con_opt_out_network_error)
                                            .positiveText(android.R.string.ok)
                                            .show()
                                }
                            }
                            progress_bar.visibility = View.GONE
                        })
                    }
                    .dismissListener {
                        optSwitch?.isChecked = false
                    }
                    .build()
        }

        val termsOfServiceCell = view.findViewById<RelativeLayout>(R.id.flybits_con_terms_of_service_cell)
        val privacyPolicyCell = view.findViewById<RelativeLayout>(R.id.flybits_con_privacy_policy_cell)
        val notificationsCell = view.findViewById<RelativeLayout>(R.id.flybits_notifications_cell)

        if (arguments?.getBoolean(ARG_SHOW_NOTIFICATIONS_CELL, false) == false){
            notificationsCell.visibility = View.GONE
        } else {
            notificationsCell.setOnClickListener {
                val startNotificationsIntent = Intent(activity, NotificationsActivity::class.java)
                startActivity(startNotificationsIntent)
            }
        }

        optSwitch?.setOnClickListener {
            if (optSwitch?.isChecked == true) {
                displayOptOutDialog()
            }
        }

        termsOfServiceCell?.setOnClickListener {
            val activityIntent = Intent(context, DocumentActivity::class.java)
            activityIntent.putExtra(DocumentActivity.EXTRA_DOCUMENT_TYPE, DocumentActivity.DOCUMENT_TYPE_TOS)
            startActivity(activityIntent)
        }

        privacyPolicyCell?.setOnClickListener {
            val activityIntent = Intent(context, DocumentActivity::class.java)
            activityIntent.putExtra(DocumentActivity.EXTRA_DOCUMENT_TYPE, DocumentActivity.DOCUMENT_TYPE_PRIVACY_POLICY)
            startActivity(activityIntent)
        }
    }

    private fun displayOptOutDialog() {
        context?.let {
            optOutDialog?.show()
        }
    }

    override fun onStop() {
        super.onStop()
        optSwitch?.isChecked = false
        optOutDialog?.dismiss()
    }

    companion object {
        const val ARG_SHOW_NOTIFICATIONS_CELL = "flybits_con_arg_show_notifications_cell"

        fun newInstance(showNotificationsCell: Boolean = false): SettingsFragment {
            val fragment = SettingsFragment()
            val arguments = Bundle()
            arguments.putBoolean(ARG_SHOW_NOTIFICATIONS_CELL, showNotificationsCell)
            fragment.arguments = arguments
            return fragment
        }
    }

}
